/*_############################################################################
  _## 
  _##  notification_log_mib.cpp  
  _## 
  _##
  _##  AGENT++ API Version 3.5.31
  _##  -----------------------------------------------
  _##  Copyright (C) 2000-2010 Frank Fock, Jochen Katz
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##  WHEREAS,  Frank  Fock  and  Jochen  Katz  are  the  owners of valuable
  _##  intellectual  property rights relating to  the AGENT++ API and wish to
  _##  license AGENT++ subject to the  terms and conditions set forth  below;
  _##  and
  _##
  _##  WHEREAS, you ("Licensee") acknowledge  that Frank Fock and Jochen Katz
  _##  have the right  to grant licenses  to the intellectual property rights
  _##  relating to  AGENT++, and that you desire  to obtain a license  to use
  _##  AGENT++ subject to the terms and conditions set forth below;
  _##
  _##  Frank  Fock    and Jochen   Katz   grants  Licensee  a  non-exclusive,
  _##  non-transferable, royalty-free  license  to use   AGENT++ and  related
  _##  materials without  charge provided the Licensee  adheres to all of the
  _##  terms and conditions of this Agreement.
  _##
  _##  By downloading, using, or  copying  AGENT++  or any  portion  thereof,
  _##  Licensee  agrees to abide  by  the intellectual property  laws and all
  _##  other   applicable laws  of  Germany,  and  to all of   the  terms and
  _##  conditions  of this Agreement, and agrees  to take all necessary steps
  _##  to  ensure that the  terms and  conditions of  this Agreement are  not
  _##  violated  by any person  or entity under the  Licensee's control or in
  _##  the Licensee's service.
  _##
  _##  Licensee shall maintain  the  copyright and trademark  notices  on the
  _##  materials  within or otherwise  related   to AGENT++, and  not  alter,
  _##  erase, deface or overprint any such notice.
  _##
  _##  Except  as specifically   provided in  this  Agreement,   Licensee  is
  _##  expressly   prohibited  from  copying,   merging,  selling,   leasing,
  _##  assigning,  or  transferring  in  any manner,  AGENT++ or  any portion
  _##  thereof.
  _##
  _##  Licensee may copy materials   within or otherwise related   to AGENT++
  _##  that bear the author's copyright only  as required for backup purposes
  _##  or for use solely by the Licensee.
  _##
  _##  Licensee may  not distribute  in any  form  of electronic  or  printed
  _##  communication the  materials  within or  otherwise  related to AGENT++
  _##  that  bear the author's  copyright, including  but  not limited to the
  _##  source   code, documentation,  help  files, examples,  and benchmarks,
  _##  without prior written consent from the authors.  Send any requests for
  _##  limited distribution rights to fock@agentpp.com.
  _##
  _##  Licensee  hereby  grants  a  royalty-free  license  to  any  and   all 
  _##  derivatives  based  upon this software  code base,  that  may  be used
  _##  as a SNMP  agent development  environment or a  SNMP agent development 
  _##  tool.
  _##
  _##  Licensee may  modify  the sources  of AGENT++ for  the Licensee's  own
  _##  purposes.  Thus, Licensee  may  not  distribute  modified  sources  of
  _##  AGENT++ without prior written consent from the authors. 
  _##
  _##  The Licensee may distribute  binaries derived from or contained within
  _##  AGENT++ provided that:
  _##
  _##  1) The Binaries are  not integrated,  bundled,  combined, or otherwise
  _##     associated with a SNMP agent development environment or  SNMP agent
  _##     development tool; and
  _##
  _##  2) The Binaries are not a documented part of any distribution material. 
  _##
  _##
  _##  THIS  SOFTWARE  IS  PROVIDED ``AS  IS''  AND  ANY  EXPRESS OR  IMPLIED
  _##  WARRANTIES, INCLUDING, BUT NOT LIMITED  TO, THE IMPLIED WARRANTIES  OF
  _##  MERCHANTABILITY AND FITNESS FOR  A PARTICULAR PURPOSE  ARE DISCLAIMED.
  _##  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
  _##  INDIRECT,   INCIDENTAL,  SPECIAL, EXEMPLARY,  OR CONSEQUENTIAL DAMAGES
  _##  (INCLUDING,  BUT NOT LIMITED  TO,  PROCUREMENT OF SUBSTITUTE  GOODS OR
  _##  SERVICES; LOSS OF  USE,  DATA, OR PROFITS; OR  BUSINESS  INTERRUPTION)
  _##  HOWEVER CAUSED  AND ON ANY THEORY  OF  LIABILITY, WHETHER IN CONTRACT,
  _##  STRICT LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
  _##  IN  ANY WAY OUT OF  THE USE OF THIS  SOFTWARE,  EVEN IF ADVISED OF THE
  _##  POSSIBILITY OF SUCH DAMAGE. 
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:07:56 CEST 2010 
  _##  
  _##########################################################################*/
#include <libagent.h>

//--AgentGen BEGIN=_BEGIN
#include <agent_pp/agent++.h>
#ifdef _SNMPv3
//--AgentGen END


#include <agent_pp/notification_log_mib.h>



/**
 *  generated by AgentGen 1.6.2 for AGENT++v3.4
 * Sun Jun 03 23:58:42 GMT+02:00 2001.
 */


//--AgentGen BEGIN=_INCLUDE

#include <agent_pp/system_group.h>
#include <agent_pp/snmp_notification_mib.h>
#include <agent_pp/mib_complex_entry.h>
#include <agent_pp/vacm.h>
#include <snmp_pp/log.h>

#ifdef AGENTPP_NAMESPACE
namespace Agentpp {
#endif

static const char *loggerModuleName = "agent++.notification_log_mib";

nlmConfigLogOperStatus::nlmConfigLogOperStatus(const Oidx& id):
  MibLeaf(id, READONLY, new SnmpInt32(1), VMODE_DEFAULT)
{
}

nlmConfigLogOperStatus::~nlmConfigLogOperStatus()
{
}

void nlmConfigLogOperStatus::get_request(Request* req, int ind)
{
	unsigned long l = 1;
	if (((nlmConfigLogAdminStatus*)my_row->get_nth(2))->get_state() == 1) {
		OctetStr f(((nlmConfigLogFilterName*)my_row->get_nth(0))->get_state());
		Oidx index(Oidx::from_string(f, true));
		 List<MibTableRow>* r =
		  snmpNotifyFilterEntry::instance->get_rows_cloned(&index,
								   true);
		if (r->size() > 0) {
			l = 2;
		}
		else {
			l = 3;
		}
		delete r;
	}
	*((SnmpInt32*)value) = l;
	MibLeaf::get_request(req, ind);
}

MibEntryPtr nlmConfigLogOperStatus::clone()
{
	MibEntryPtr other = new nlmConfigLogOperStatus(oid);
	((nlmConfigLogOperStatus*)other)->replace_value(value->clone());
	((nlmConfigLogOperStatus*)other)->set_reference_to_table(my_table);
	return other;
}
//--AgentGen END


/**
 *  nlmConfigGlobalEntryLimit
 *
 */

nlmConfigGlobalEntryLimit* nlmConfigGlobalEntryLimit::instance = 0;

nlmConfigGlobalEntryLimit::nlmConfigGlobalEntryLimit():
   MibLeaf(oidNlmConfigGlobalEntryLimit, READWRITE, new Gauge32(0), VMODE_DEFAULT)
{
	// This leaf object is a singleton. In order to access it use
	// the static pointer nlmConfigGlobalEntryLimit::instance.
	instance = this;

	//--AgentGen BEGIN=nlmConfigGlobalEntryLimit::nlmConfigGlobalEntryLimit
	//--AgentGen END

}

nlmConfigGlobalEntryLimit::~nlmConfigGlobalEntryLimit()
{

	//--AgentGen BEGIN=nlmConfigGlobalEntryLimit::~nlmConfigGlobalEntryLimit
	//--AgentGen END
}

void nlmConfigGlobalEntryLimit::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=nlmConfigGlobalEntryLimit::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

unsigned long nlmConfigGlobalEntryLimit::get_state() const
{
	return (unsigned long)*((Gauge32*)value);
}

void nlmConfigGlobalEntryLimit::set_state(unsigned long l)
{

	//--AgentGen BEGIN=nlmConfigGlobalEntryLimit::set_state
	//--AgentGen END
	*((Gauge32*)value) = l;
}

int nlmConfigGlobalEntryLimit::set(const Vbx& vb)
{

	//--AgentGen BEGIN=nlmConfigGlobalEntryLimit::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

bool nlmConfigGlobalEntryLimit::value_ok(const Vbx& vb) const
{
	// shut up compiler about unused parameter(s)
	(void)vb;

	//--AgentGen BEGIN=nlmConfigGlobalEntryLimit::value_ok
	//--AgentGen END
	return true;
}

int nlmConfigGlobalEntryLimit::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=nlmConfigGlobalEntryLimit::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=nlmConfigGlobalEntryLimit
//--AgentGen END




/**
 *  nlmConfigGlobalAgeOut
 *
 */

nlmConfigGlobalAgeOut* nlmConfigGlobalAgeOut::instance = 0;

nlmConfigGlobalAgeOut::nlmConfigGlobalAgeOut():
   MibLeaf(oidNlmConfigGlobalAgeOut, READWRITE, new Gauge32(1440), VMODE_DEFAULT)
{
	// This leaf object is a singleton. In order to access it use
	// the static pointer nlmConfigGlobalAgeOut::instance.
	instance = this;

	//--AgentGen BEGIN=nlmConfigGlobalAgeOut::nlmConfigGlobalAgeOut
	//--AgentGen END

}

nlmConfigGlobalAgeOut::~nlmConfigGlobalAgeOut()
{

	//--AgentGen BEGIN=nlmConfigGlobalAgeOut::~nlmConfigGlobalAgeOut
	//--AgentGen END
}

void nlmConfigGlobalAgeOut::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=nlmConfigGlobalAgeOut::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

unsigned long nlmConfigGlobalAgeOut::get_state() const
{
	return (unsigned long)*((Gauge32*)value);
}

void nlmConfigGlobalAgeOut::set_state(unsigned long l)
{

	//--AgentGen BEGIN=nlmConfigGlobalAgeOut::set_state
	//--AgentGen END
	*((Gauge32*)value) = l;
}

int nlmConfigGlobalAgeOut::set(const Vbx& vb)
{

	//--AgentGen BEGIN=nlmConfigGlobalAgeOut::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

bool nlmConfigGlobalAgeOut::value_ok(const Vbx& vb) const
{
	// shut up compiler about unused parameter(s)
	(void)vb;

	//--AgentGen BEGIN=nlmConfigGlobalAgeOut::value_ok
	//--AgentGen END
	return true;
}

int nlmConfigGlobalAgeOut::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=nlmConfigGlobalAgeOut::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=nlmConfigGlobalAgeOut
//--AgentGen END




/**
 *  nlmConfigLogFilterName
 *
 */

nlmConfigLogFilterName::nlmConfigLogFilterName(const Oidx& id):
   MibLeaf(id, READCREATE, new OctetStr(""), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=nlmConfigLogFilterName::nlmConfigLogFilterName
	//--AgentGen END

}

nlmConfigLogFilterName::~nlmConfigLogFilterName()
{

	//--AgentGen BEGIN=nlmConfigLogFilterName::~nlmConfigLogFilterName
	//--AgentGen END
}

MibEntryPtr nlmConfigLogFilterName::clone()
{
	MibEntryPtr other = new nlmConfigLogFilterName(oid);
	((nlmConfigLogFilterName*)other)->replace_value(value->clone());
	((nlmConfigLogFilterName*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=nlmConfigLogFilterName::clone
	//--AgentGen END
	return other;
}

void nlmConfigLogFilterName::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=nlmConfigLogFilterName::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

OctetStr nlmConfigLogFilterName::get_state() const
{
	return *((OctetStr*)value);
}

void nlmConfigLogFilterName::set_state(const OctetStr& s)
{

	//--AgentGen BEGIN=nlmConfigLogFilterName::set_state
	//--AgentGen END
	*((OctetStr*)value) = s;
}

int nlmConfigLogFilterName::set(const Vbx& vb)
{

	//--AgentGen BEGIN=nlmConfigLogFilterName::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

bool nlmConfigLogFilterName::value_ok(const Vbx& vb) const
{
	OctetStr v;
	if (vb.get_value(v) != SNMP_CLASS_SUCCESS)
	    return false;

	//--AgentGen BEGIN=nlmConfigLogFilterName::value_ok
	//--AgentGen END
	return true;
}

int nlmConfigLogFilterName::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	Vb vb(req->get_value(ind));
	OctetStr v;
	if (vb.get_value(v) != SNMP_CLASS_SUCCESS)
	    return SNMP_ERROR_WRONG_TYPE;
	if (!(v.len() <= 32))
		 return SNMP_ERROR_WRONG_LENGTH;

	//--AgentGen BEGIN=nlmConfigLogFilterName::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=nlmConfigLogFilterName
//--AgentGen END




/**
 *  nlmConfigLogEntryLimit
 *
 */

nlmConfigLogEntryLimit::nlmConfigLogEntryLimit(const Oidx& id):
   MibLeaf(id, READCREATE, new Gauge32(0), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=nlmConfigLogEntryLimit::nlmConfigLogEntryLimit
	//--AgentGen END

}

nlmConfigLogEntryLimit::~nlmConfigLogEntryLimit()
{

	//--AgentGen BEGIN=nlmConfigLogEntryLimit::~nlmConfigLogEntryLimit
	//--AgentGen END
}

MibEntryPtr nlmConfigLogEntryLimit::clone()
{
	MibEntryPtr other = new nlmConfigLogEntryLimit(oid);
	((nlmConfigLogEntryLimit*)other)->replace_value(value->clone());
	((nlmConfigLogEntryLimit*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=nlmConfigLogEntryLimit::clone
	//--AgentGen END
	return other;
}

void nlmConfigLogEntryLimit::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=nlmConfigLogEntryLimit::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

unsigned long nlmConfigLogEntryLimit::get_state() const
{
	return (unsigned long)*((Gauge32*)value);
}

void nlmConfigLogEntryLimit::set_state(unsigned long l)
{

	//--AgentGen BEGIN=nlmConfigLogEntryLimit::set_state
	//--AgentGen END
	*((Gauge32*)value) = l;
}

int nlmConfigLogEntryLimit::set(const Vbx& vb)
{

	//--AgentGen BEGIN=nlmConfigLogEntryLimit::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

bool nlmConfigLogEntryLimit::value_ok(const Vbx& vb) const
{
	// shut up compiler about unused parameter(s)
	(void)vb;

	//--AgentGen BEGIN=nlmConfigLogEntryLimit::value_ok
	//--AgentGen END
	return true;
}

int nlmConfigLogEntryLimit::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=nlmConfigLogEntryLimit::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=nlmConfigLogEntryLimit
//--AgentGen END




/**
 *  nlmConfigLogAdminStatus
 *
 */

nlmConfigLogAdminStatus::nlmConfigLogAdminStatus(const Oidx& id):
   MibLeaf(id, READCREATE, new SnmpInt32(1), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=nlmConfigLogAdminStatus::nlmConfigLogAdminStatus
	//--AgentGen END

}

nlmConfigLogAdminStatus::~nlmConfigLogAdminStatus()
{

	//--AgentGen BEGIN=nlmConfigLogAdminStatus::~nlmConfigLogAdminStatus
	//--AgentGen END
}

MibEntryPtr nlmConfigLogAdminStatus::clone()
{
	MibEntryPtr other = new nlmConfigLogAdminStatus(oid);
	((nlmConfigLogAdminStatus*)other)->replace_value(value->clone());
	((nlmConfigLogAdminStatus*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=nlmConfigLogAdminStatus::clone
	//--AgentGen END
	return other;
}

void nlmConfigLogAdminStatus::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=nlmConfigLogAdminStatus::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

long nlmConfigLogAdminStatus::get_state() const
{
	return (long)*((SnmpInt32*)value);
}

void nlmConfigLogAdminStatus::set_state(long l)
{

	//--AgentGen BEGIN=nlmConfigLogAdminStatus::set_state
	//--AgentGen END
	*((SnmpInt32*)value) = l;
}

int nlmConfigLogAdminStatus::set(const Vbx& vb)
{

	//--AgentGen BEGIN=nlmConfigLogAdminStatus::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

bool nlmConfigLogAdminStatus::value_ok(const Vbx& vb) const
{
	long v;
	if (vb.get_value(v) != SNMP_CLASS_SUCCESS)
	    return false;
	if ((v != 1)
	     && (v != 2)) return false;

	//--AgentGen BEGIN=nlmConfigLogAdminStatus::value_ok
	//--AgentGen END
	return true;
}

int nlmConfigLogAdminStatus::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=nlmConfigLogAdminStatus::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=nlmConfigLogAdminStatus
//--AgentGen END




/**
 *  nlmConfigLogStorageType
 *
 */

nlmConfigLogStorageType::nlmConfigLogStorageType(const Oidx& id):
   StorageType(id, 3)
{

	//--AgentGen BEGIN=nlmConfigLogStorageType::nlmConfigLogStorageType
	//--AgentGen END

}

nlmConfigLogStorageType::~nlmConfigLogStorageType()
{

	//--AgentGen BEGIN=nlmConfigLogStorageType::~nlmConfigLogStorageType
	//--AgentGen END
}

MibEntryPtr nlmConfigLogStorageType::clone()
{
	MibEntryPtr other = new nlmConfigLogStorageType(oid);
	((nlmConfigLogStorageType*)other)->replace_value(value->clone());
	((nlmConfigLogStorageType*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=nlmConfigLogStorageType::clone
	//--AgentGen END
	return other;
}

void nlmConfigLogStorageType::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=nlmConfigLogStorageType::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

long nlmConfigLogStorageType::get_state() const
{
	return (long)*((SnmpInt32*)value);
}

void nlmConfigLogStorageType::set_state(long l)
{

	//--AgentGen BEGIN=nlmConfigLogStorageType::set_state
	//--AgentGen END
	*((SnmpInt32*)value) = l;
}

int nlmConfigLogStorageType::set(const Vbx& vb)
{

	//--AgentGen BEGIN=nlmConfigLogStorageType::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

bool nlmConfigLogStorageType::value_ok(const Vbx& vb) const
{
	long v;
	if (vb.get_value(v) != SNMP_CLASS_SUCCESS)
	    return false;
	if ((v < 1) || (v > 5)
	    ) return false;

	//--AgentGen BEGIN=nlmConfigLogStorageType::value_ok
	//--AgentGen END
	return true;
}

int nlmConfigLogStorageType::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = StorageType::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=nlmConfigLogStorageType::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=nlmConfigLogStorageType
//--AgentGen END




/**
 *  nlmConfigLogEntryStatus
 *
 */

nlmConfigLogEntryStatus::nlmConfigLogEntryStatus(const Oidx& id):
   snmpRowStatus(id, READCREATE)

{

	//--AgentGen BEGIN=nlmConfigLogEntryStatus::nlmConfigLogEntryStatus
	//--AgentGen END

}

nlmConfigLogEntryStatus::~nlmConfigLogEntryStatus()
{

	//--AgentGen BEGIN=nlmConfigLogEntryStatus::~nlmConfigLogEntryStatus
	//--AgentGen END
}

MibEntryPtr nlmConfigLogEntryStatus::clone()
{
	MibEntryPtr other = new nlmConfigLogEntryStatus(oid);
	((nlmConfigLogEntryStatus*)other)->replace_value(value->clone());
	((nlmConfigLogEntryStatus*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=nlmConfigLogEntryStatus::clone
	//--AgentGen END
	return other;
}

long nlmConfigLogEntryStatus::get_state() const
{
	return (long)*((SnmpInt32*)value);
}

void nlmConfigLogEntryStatus::set_state(long l)
{

	//--AgentGen BEGIN=nlmConfigLogEntryStatus::set_state
	//--AgentGen END
	*((SnmpInt32*)value) = l;
}

int nlmConfigLogEntryStatus::set(const Vbx& vb)
{

	//--AgentGen BEGIN=nlmConfigLogEntryStatus::set
	//--AgentGen END
	return snmpRowStatus::set(vb);
}

int nlmConfigLogEntryStatus::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = snmpRowStatus::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=nlmConfigLogEntryStatus::prepare_set_request
	Vbx vb(req->get_value(ind));
	unsigned long l = 0;
	if (vb.get_value(l) != SNMP_CLASS_SUCCESS)
	    return SNMP_ERROR_WRONG_TYPE;
	if ((l == rowCreateAndGo) || (l == rowCreateAndWait)) {
		// initialize viewName;
		OctetStr secName, viewName;
		req->get_security_name(secName);
		int vacmErrorCode =
		  Mib::instance->get_request_list()->get_vacm()->
		  getViewName(req->get_security_model(),
			      secName,
			      req->get_pdu()->get_security_level(),
			      mibView_notify,
			      req->get_context(), viewName);
		if (vacmErrorCode != VACM_viewFound)
			return SNMP_ERROR_NO_ACCESS;
	}
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=nlmConfigLogEntryStatus

int nlmConfigLogEntryStatus::commit_set_request(Request* req, int ind)
{
	int status;
	if ((status = snmpRowStatus::commit_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	// save security info for further reference
	Vbx vb(req->get_value(ind));
	unsigned long l = 0;
	vb.get_value(l);
	if ((l == rowCreateAndGo) || (l == rowCreateAndWait)) {
		// initialize viewName;
		OctetStr secName, viewName;
		req->get_security_name(secName);
		int vacmErrorCode =
		  Mib::instance->get_request_list()->get_vacm()->
		  getViewName(req->get_security_model(),
			      secName,
			      req->get_pdu()->get_security_level(),
			      mibView_notify,
			      req->get_context(), viewName);
		if (vacmErrorCode != VACM_viewFound)
			return SNMP_ERROR_COMITFAIL;

		my_row->get_nth(nNlmConfigLogEntryStatus+1)->
		  set_value(viewName);
	}
	return SNMP_ERROR_SUCCESS;
}

//--AgentGen END




/**
 *  nlmStatsGlobalNotificationsLogged
 *
 */

nlmStatsGlobalNotificationsLogged* nlmStatsGlobalNotificationsLogged::instance = 0;

nlmStatsGlobalNotificationsLogged::nlmStatsGlobalNotificationsLogged():
   MibLeaf(oidNlmStatsGlobalNotificationsLogged, READONLY, new Counter32())
{
	// This leaf object is a singleton. In order to access it use
	// the static pointer nlmStatsGlobalNotificationsLogged::instance.
	instance = this;

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsLogged::nlmStatsGlobalNotificationsLogged
	//--AgentGen END

}

nlmStatsGlobalNotificationsLogged::~nlmStatsGlobalNotificationsLogged()
{

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsLogged::~nlmStatsGlobalNotificationsLogged
	//--AgentGen END
}

void nlmStatsGlobalNotificationsLogged::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsLogged::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

unsigned long nlmStatsGlobalNotificationsLogged::get_state() const
{
	return (unsigned long)*((Counter32*)value);
}

void nlmStatsGlobalNotificationsLogged::set_state(unsigned long l)
{

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsLogged::set_state
	//--AgentGen END
	*((Counter32*)value) = l;
}

unsigned long nlmStatsGlobalNotificationsLogged::inc()
{

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsLogged::inc
	//--AgentGen END
	unsigned long l = get_state();
	set_state(++l);
	return l;
}


//--AgentGen BEGIN=nlmStatsGlobalNotificationsLogged
//--AgentGen END




/**
 *  nlmStatsGlobalNotificationsBumped
 *
 */

nlmStatsGlobalNotificationsBumped* nlmStatsGlobalNotificationsBumped::instance = 0;

nlmStatsGlobalNotificationsBumped::nlmStatsGlobalNotificationsBumped():
   MibLeaf(oidNlmStatsGlobalNotificationsBumped, READONLY, new Counter32())
{
	// This leaf object is a singleton. In order to access it use
	// the static pointer nlmStatsGlobalNotificationsBumped::instance.
	instance = this;

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsBumped::nlmStatsGlobalNotificationsBumped
	//--AgentGen END

}

nlmStatsGlobalNotificationsBumped::~nlmStatsGlobalNotificationsBumped()
{

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsBumped::~nlmStatsGlobalNotificationsBumped
	//--AgentGen END
}

void nlmStatsGlobalNotificationsBumped::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsBumped::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

unsigned long nlmStatsGlobalNotificationsBumped::get_state() const
{
	return (unsigned long)*((Counter32*)value);
}

void nlmStatsGlobalNotificationsBumped::set_state(unsigned long l)
{

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsBumped::set_state
	//--AgentGen END
	*((Counter32*)value) = l;
}

unsigned long nlmStatsGlobalNotificationsBumped::inc()
{

	//--AgentGen BEGIN=nlmStatsGlobalNotificationsBumped::inc
	//--AgentGen END
	unsigned long l = get_state();
	set_state(++l);
	return l;
}


//--AgentGen BEGIN=nlmStatsGlobalNotificationsBumped
//--AgentGen END




/**
 *  nlmConfigLogEntry
 *
 */

nlmConfigLogEntry* nlmConfigLogEntry::instance = 0;

const index_info indNlmConfigLogEntry[1] = {
	{ sNMP_SYNTAX_OCTETS, false, 0, 255 } };

nlmConfigLogEntry::nlmConfigLogEntry():
   StorageTable(oidNlmConfigLogEntry, indNlmConfigLogEntry, 1)
{
	// This table object is a singleton. In order to access it use
	// the static pointer nlmConfigLogEntry::instance.
	instance = this;

	add_col(new nlmConfigLogFilterName(colNlmConfigLogFilterName));
	add_col(new nlmConfigLogEntryLimit(colNlmConfigLogEntryLimit));
	add_col(new nlmConfigLogAdminStatus(colNlmConfigLogAdminStatus));
	add_col(new MibLeaf(colNlmConfigLogOperStatus, READONLY, new SnmpInt32()));
	add_storage_col(new nlmConfigLogStorageType(colNlmConfigLogStorageType));
	add_col(new nlmConfigLogEntryStatus(colNlmConfigLogEntryStatus));

	//--AgentGen BEGIN=nlmConfigLogEntry::nlmConfigLogEntry
	replace_col(3, new nlmConfigLogOperStatus(colNlmConfigLogOperStatus));
	add_col(new MibLeaf("100", NOACCESS, new OctetStr())); //viewName
	//--AgentGen END
}

nlmConfigLogEntry::~nlmConfigLogEntry()
{

	//--AgentGen BEGIN=nlmConfigLogEntry::~nlmConfigLogEntry
	//--AgentGen END
}

void nlmConfigLogEntry::row_added(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	(void)index;
	(void)src;
	// The row 'row' with 'index' has been added to the table.

	//--AgentGen BEGIN=nlmConfigLogEntry::row_added
	//--AgentGen END
}

void nlmConfigLogEntry::row_delete(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	(void)index;
	(void)src;
	// The row 'row' with 'index' will be deleted.

	//--AgentGen BEGIN=nlmConfigLogEntry::row_delete
	//--AgentGen END
}

void nlmConfigLogEntry::row_init(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	(void)index;
	(void)src;
	// The row 'row' with 'index' has been intialized.

	//--AgentGen BEGIN=nlmConfigLogEntry::row_init
	//--AgentGen END
}



void nlmConfigLogEntry::set_row(MibTableRow* r, const OctetStr& p0, unsigned long p1, long p2, long p3, long p4, long p5)
{
	r->get_nth(0)->replace_value(new OctetStr(p0));
	r->get_nth(1)->replace_value(new Gauge32(p1));
	r->get_nth(2)->replace_value(new SnmpInt32(p2));
	r->get_nth(3)->replace_value(new SnmpInt32(p3));
	r->get_nth(4)->replace_value(new SnmpInt32(p4));
	r->get_nth(5)->replace_value(new SnmpInt32(p5));
}


//--AgentGen BEGIN=nlmConfigLogEntry
//--AgentGen END




/**
 *  nlmStatsLogEntry
 *
 */

nlmStatsLogEntry* nlmStatsLogEntry::instance = 0;

const index_info indNlmStatsLogEntry[1] = {
	{ sNMP_SYNTAX_OCTETS, false, 0, 255 } };

nlmStatsLogEntry::nlmStatsLogEntry():
   MibTable(oidNlmStatsLogEntry, indNlmStatsLogEntry, 1)
{
	// This table object is a singleton. In order to access it use
	// the static pointer nlmStatsLogEntry::instance.
	instance = this;

	add_col(new MibLeaf(colNlmStatsLogNotificationsLogged, READONLY, new Counter32()));
	add_col(new MibLeaf(colNlmStatsLogNotificationsBumped, READONLY, new Counter32()));

	//--AgentGen BEGIN=nlmStatsLogEntry::nlmStatsLogEntry
	nlmConfigLogEntry::instance->add_listener(this);
	//--AgentGen END
}

nlmStatsLogEntry::~nlmStatsLogEntry()
{

	//--AgentGen BEGIN=nlmStatsLogEntry::~nlmStatsLogEntry
	//--AgentGen END
}

void nlmStatsLogEntry::row_added(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	// The row 'row' with 'index' has been added to the table.

	//--AgentGen BEGIN=nlmStatsLogEntry::row_added
	if (src)
		add_row(index);
	//--AgentGen END
}

void nlmStatsLogEntry::row_delete(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	// The row 'row' with 'index' will be deleted.

	//--AgentGen BEGIN=nlmStatsLogEntry::row_delete
	if (src)
		remove_row(index);
	//--AgentGen END
}

void nlmStatsLogEntry::row_init(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	// The row 'row' with 'index' has been intialized.

	//--AgentGen BEGIN=nlmStatsLogEntry::row_init
	if (src)
		add_row(index);
	//--AgentGen END
}



void nlmStatsLogEntry::set_row(MibTableRow* r, unsigned long p0, unsigned long p1)
{
	r->get_nth(0)->replace_value(new Counter32(p0));
	r->get_nth(1)->replace_value(new Counter32(p1));
}


//--AgentGen BEGIN=nlmStatsLogEntry
//--AgentGen END




/**
 *  nlmLogEntry
 *
 */

nlmLogEntry* nlmLogEntry::instance = 0;

const index_info indNlmLogEntry[2] = {
	{ sNMP_SYNTAX_OCTETS, false, 0, 255 },
	 { sNMP_SYNTAX_INT, false, 1, 1 } };

nlmLogEntry::nlmLogEntry():
   MibTable(oidNlmLogEntry, indNlmLogEntry, 2)
{
	// This table object is a singleton. In order to access it use
	// the static pointer nlmLogEntry::instance.
	instance = this;

	add_col(new MibLeaf(colNlmLogTime, READONLY, new TimeTicks()));
	add_col(new MibLeaf(colNlmLogDateAndTime, READONLY, new OctetStr()));
	add_col(new MibLeaf(colNlmLogEngineID, READONLY, new OctetStr()));
	add_col(new MibLeaf(colNlmLogEngineTAddress, READONLY, new OctetStr()));
	add_col(new MibLeaf(colNlmLogEngineTDomain, READONLY, new Oid()));
	add_col(new MibLeaf(colNlmLogContextEngineID, READONLY, new OctetStr()));
	add_col(new MibLeaf(colNlmLogContextName, READONLY, new OctetStr()));
	add_col(new MibLeaf(colNlmLogNotificationID, READONLY, new Oid()));

	//--AgentGen BEGIN=nlmLogEntry::nlmLogEntry
	replace_col(nNlmLogDateAndTime,
		    new DateAndTime(colNlmLogDateAndTime, READONLY,
				    VMODE_DEFAULT));
	nlmConfigLogEntry::instance->add_listener(this);
	//--AgentGen END
}

nlmLogEntry::~nlmLogEntry()
{

	//--AgentGen BEGIN=nlmLogEntry::~nlmLogEntry
	entries.clear();
	//--AgentGen END
}

void nlmLogEntry::row_added(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// The row 'row' with 'index' has been added to the table.

	//--AgentGen BEGIN=nlmLogEntry::row_added
	// new log configuration?
	if (src == nlmConfigLogEntry::instance) {
		Vbx vb(index);
		vb.set_value(0ul);
		// add log index
		logIndexes.add(new MibStaticEntry(vb));
	}
	else {
		entries.add(row);
	}
	//--AgentGen END
}

void nlmLogEntry::row_delete(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// The row 'row' with 'index' will be deleted.

	//--AgentGen BEGIN=nlmLogEntry::row_delete
	if (src == nlmConfigLogEntry::instance) {
		Oidx ind(index);
		logIndexes.remove(&ind);
	}
	else {
		entries.remove(row);
	}
	//--AgentGen END
}

void nlmLogEntry::row_init(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	// The row 'row' with 'index' has been intialized.

	//--AgentGen BEGIN=nlmLogEntry::row_init
	if (src == nlmConfigLogEntry::instance) {
		Vbx vb(index);
		vb.set_value(0ul);
		logIndexes.add(new MibStaticEntry(vb));
	}
	//--AgentGen END
}



void nlmLogEntry::set_row(MibTableRow* r, unsigned long p0, const OctetStr& p1, const OctetStr& p2, const OctetStr& p3, const char* p4, const OctetStr& p5, const OctetStr& p6, const char* p7)
{
	r->get_nth(0)->replace_value(new TimeTicks(p0));
	r->get_nth(1)->replace_value(new OctetStr(p1));
	r->get_nth(2)->replace_value(new OctetStr(p2));
	r->get_nth(3)->replace_value(new OctetStr(p3));
	r->get_nth(4)->replace_value(new Oid(p4));
	r->get_nth(5)->replace_value(new OctetStr(p5));
	r->get_nth(6)->replace_value(new OctetStr(p6));
	r->get_nth(7)->replace_value(new Oid(p7));
}


//--AgentGen BEGIN=nlmLogEntry

bool nlmLogEntry::check_access(const Pdux& pdu, MibTableRow* profile)
{
	Vbx* vbs = new Vbx[pdu.get_vb_count()];
	pdu.get_vblist(vbs, pdu.get_vb_count());
	OctetStr viewName;

	profile->get_nth(nNlmConfigLogEntryStatus+1)->
	  get_value(viewName);
	// an empty viewName denotes a system entry
	// that automatically has access
	if (viewName.len() == 0) {
		delete[] vbs;
		return true;
	}

	bool accessAllowed = true;
	for (int i=0; i<pdu.get_vb_count(); i++) {

	    if (Mib::instance->get_request_list()->get_vacm()->
		isAccessAllowed(viewName,
				vbs[i].get_oid()) !=
		VACM_accessAllowed) {
	      accessAllowed = false;
	      break;
	    }
	  }

	  if (accessAllowed) {
	    Oid id;
	    pdu.get_notify_id(id);
	    accessAllowed =
	      (Mib::instance->get_request_list()->get_vacm()->
	       isAccessAllowed(viewName, id) == VACM_accessAllowed);
	  }
	  if (!accessAllowed) {
	    LOG_BEGIN(loggerModuleName, EVENT_LOG | 2);
	    LOG("Notification not logged (reason)(viewName)");
	    LOG("no access");
	    LOG(viewName.get_printable());
	    LOG_END;
	  }
	  delete[] vbs;
	  return accessAllowed;
}

void nlmLogEntry::add_notification(const SnmpTarget& target,
				   const Pdux& pdu,
				   const OctetStr& engineID)
{
	Oid nid;
	pdu.get_notify_id(nid);
	switch (target.get_type()) {
	case SnmpTarget::type_ctarget:
	case SnmpTarget::type_utarget:
	  break;
	case SnmpTarget::type_base:
	  LOG_BEGIN(loggerModuleName, ERROR_LOG | 1);
	  LOG("nlmLogEntry: invalid target given");
	  LOG_END;
	  return;
	}
	OctetStr address;
	GenAddress addr;
	target.get_address(addr);
	UdpAddress* udpAddress = new UdpAddress(addr);
	IpAddress ip(*udpAddress);
	for (int i=0; i<4; i++) {
		address += (unsigned char)ip[i];
	}
	address += (udpAddress->get_port() >> 8);
	address += (udpAddress->get_port() & 0x00FF);
	delete udpAddress;

	LOG_BEGIN(loggerModuleName, EVENT_LOG | 5);
	LOG("NotificationLog: Logging (target)(oid)(vbs)");
	LOG(address.get_printable_hex());
	LOG(nid.get_printable());
	LOG(pdu.get_vb_count());
	LOG_END;

	Vbx* vbs = new Vbx[pdu.get_vb_count()];
	pdu.get_vblist(vbs, pdu.get_vb_count());

	start_synch();
	List<MibTableRow>* logs =
	  nlmConfigLogEntry::instance->get_rows_cloned();
	nlmStatsLogEntry::instance->start_synch();
	ListCursor<MibTableRow> cur;
	for (cur.init(logs); cur.get(); cur.next()) {
		// ignore disabled log entries
		if (((nlmConfigLogAdminStatus*)cur.get()->
		     get_nth(nNlmConfigLogAdminStatus))->get_state() ==
		    nlmConfigLogAdminStatus::e_disabled)
			continue;
		OctetStr profileName =
		  ((nlmConfigLogFilterName*)cur.get()->
		   get_nth(nNlmConfigLogFilterName))->get_state();
		// check access
		if ((profileName.len()>0) && (!check_access(pdu, cur.get())))
			continue;
		// check filter
		if ((profileName.len()==0) ||
		    (!snmpNotifyFilterEntry::
		     passes_filter(nid,
				   Oidx::from_string(profileName, true),
				   vbs,
				   pdu.get_vb_count())))
			continue;

		// OK, now log the notification
		unsigned long l = 0;
		Vbx* vb = logIndexes.find(cur.get()->key());
		if (!vb)
			continue;
		vb->get_value(l);
		Oidx newIndex(cur.get()->get_index());
		newIndex += ++l;
		vb->set_value(l);

		MibTableRow* r = add_row(newIndex);
		OctetStr ceid;
		pdu.get_context_engine_id(ceid);
		OctetStr cn;
		pdu.get_context_name(cn);
		set_row(r, sysUpTime::get(),
			((DateAndTime*)r->get_nth(1))->get_state(),
			engineID,
			address,
			"1.3.6.1.6.1.1",
			ceid, cn, nid.get_printable());

		nlmLogVariableEntry::instance->start_synch();
		for (int i=0; i<pdu.get_vb_count(); i++) {
			Vbx vb;
			pdu.get_vb(vb, i);
			nlmLogVariableEntry::instance->add_variable(newIndex,
								    i,
								    vb);
		}
		nlmLogVariableEntry::instance->end_synch();
		MibTableRow* s =
		nlmStatsLogEntry::instance->find_index(cur.get()->get_index());
		Counter32 ll = 0;
		if (s) {
			s->get_nth(nNlmStatsLogNotificationsLogged)->
			  get_value(ll);
			ll = (unsigned long)ll + 1ul;
			s->get_nth(nNlmStatsLogNotificationsLogged)->
			  set_value(ll);
			nlmStatsGlobalNotificationsLogged::instance->inc();
		}
	}
	delete[] vbs;
	check_limits(logs);
	delete logs;
	nlmStatsLogEntry::instance->end_synch();
	end_synch();
}

void nlmLogEntry::check_limits(List<MibTableRow>* logs)
{
	unsigned long global_limit =
	  nlmConfigGlobalEntryLimit::instance->get_state();
	if (global_limit > 0) {
		long v = size() - global_limit;
		if (v > 0) {
			ListCursor<MibTableRow> cur;
			int i=0;
			for (cur.init(&entries); (i<v) && (cur.get());) {
				MibTableRow* victim = cur.get();
				cur.next();
				remove_row(victim->get_index());
				i++;
				nlmStatsGlobalNotificationsBumped::instance->
				  inc();
			}
		}
	}
	unsigned long age_out =
	  nlmConfigGlobalAgeOut::instance->get_state();
	if (age_out > 0) {
		ListCursor<MibTableRow> cur;
		unsigned long uptime = sysUpTime::get();
		for (cur.init(&entries); cur.get();) {
			MibTableRow* victim = cur.get();
			cur.next();
			unsigned long logtime = 0;
			victim->get_nth(nNlmLogTime)->get_value(logtime);
			// age_out counts minutes -> 60 * 100 1/100 seconds
			if (uptime - logtime > age_out * 6000) {
				Oidx profile(victim->get_index());
				profile.trim();
				MibTableRow* s =
				  nlmConfigLogEntry::instance->
				  find_index(profile);
				if (s) {
				  unsigned long ll = 0;
				  s->get_nth(nNlmStatsLogNotificationsBumped)->
				    get_value(ll);
				  ll++;
				  s->get_nth(nNlmStatsLogNotificationsBumped)->
				    set_value(ll);
				}
				remove_row(victim->get_index());
			}
			else
				break;
		}
	}
	ListCursor<MibTableRow> cur;
	for (cur.init(logs); cur.get(); cur.next()) {
		unsigned long entry_limit = 0;
		cur.get()->get_nth(nNlmConfigLogEntryLimit)->
		  get_value(entry_limit);
		if (entry_limit == 0)
			continue;
		OidListCursor<MibTableRow> c(&content);
		unsigned long n = 0;
		for (c.lookup(cur.get()->key()); c.get(); c.next()) {
			Oidx ind(c.get()->get_index().cut_right(1));
			if (ind > cur.get()->get_index()) {
				break;
			}
			if (ind == cur.get()->get_index())
				n++;
		}
		if ((entry_limit > 0) && (n > entry_limit)) {
			n = n - entry_limit;
			c.init(&content);
			for (c.lookup(cur.get()->key());
			     ((n > 0) && (c.get())); ) {
				Oidx ind(c.get()->get_index().cut_right(1));
				if (ind > cur.get()->get_index())
					break;
				if (ind != cur.get()->get_index()) {
					c.next();
					continue;
				}
				nlmStatsGlobalNotificationsBumped::instance->
				  inc();

				Counter32 ll;
				MibTableRow* r =
				  nlmStatsLogEntry::instance->
				  find_index(cur.get()->get_index());
				if (r) {
				  MibLeaf* l = r->
				    get_nth(nNlmStatsLogNotificationsBumped);
				  l->get_value(ll);
				  ll = (unsigned long)ll + 1ul;
				  l->set_value(ll);
				}
				MibTableRow* victim = c.get();
				c.next();
				remove_row(victim->get_index());
				n--;
			}
		}
	}
}
//--AgentGen END




/**
 *  nlmLogVariableEntry
 *
 */

nlmLogVariableEntry* nlmLogVariableEntry::instance = 0;

const index_info indNlmLogVariableEntry[3] = {
	{ sNMP_SYNTAX_OCTETS, false, 0, 255 },
	 { sNMP_SYNTAX_INT, false, 1, 1 },
	 { sNMP_SYNTAX_INT, false, 1, 1 } };

nlmLogVariableEntry::nlmLogVariableEntry():
   MibTable(oidNlmLogVariableEntry, indNlmLogVariableEntry, 3)
{
	// This table object is a singleton. In order to access it use
	// the static pointer nlmLogVariableEntry::instance.
	instance = this;

	add_col(new MibLeaf(colNlmLogVariableID, READONLY, new Oid()));
	add_col(new MibLeaf(colNlmLogVariableValueType, READONLY, new SnmpInt32()));
	add_col(new MibLeaf(colNlmLogVariableCounter32Val, READONLY, new Counter32()));
	add_col(new MibLeaf(colNlmLogVariableUnsigned32Val, READONLY, new Gauge32()));
	add_col(new MibLeaf(colNlmLogVariableTimeTicksVal, READONLY, new TimeTicks()));
	add_col(new MibLeaf(colNlmLogVariableInteger32Val, READONLY, new SnmpInt32()));
	add_col(new MibLeaf(colNlmLogVariableOctetStringVal, READONLY, new OctetStr()));
	add_col(new MibLeaf(colNlmLogVariableIpAddressVal, READONLY, new IpAddress("0.0.0.0")));
	add_col(new MibLeaf(colNlmLogVariableOidVal, READONLY, new Oid()));
	add_col(new MibLeaf(colNlmLogVariableCounter64Val, READONLY, new Counter64()));
	add_col(new MibLeaf(colNlmLogVariableOpaqueVal, READONLY, new OpaqueStr()));

	//--AgentGen BEGIN=nlmLogVariableEntry::nlmLogVariableEntry
	nlmLogEntry::instance->add_listener(this);
	//--AgentGen END
}

nlmLogVariableEntry::~nlmLogVariableEntry()
{

	//--AgentGen BEGIN=nlmLogVariableEntry::~nlmLogVariableEntry
	//--AgentGen END
}

void nlmLogVariableEntry::row_added(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	(void)index;
	(void)src;
	// The row 'row' with 'index' has been added to the table.

	//--AgentGen BEGIN=nlmLogVariableEntry::row_added
	//--AgentGen END
}

void nlmLogVariableEntry::row_delete(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	// The row 'row' with 'index' will be deleted.

	//--AgentGen BEGIN=nlmLogVariableEntry::row_delete
	if (src == nlmLogEntry::instance) {
		OidListCursor<MibTableRow> cur(&content);
		Oidx ind(index);
		for (cur.lookup(&ind);
		     ((cur.get()) &&
		      (cur.get()->get_index().cut_right(1)==index));) {
			MibTableRow* victim = cur.get();
			cur.next();
			remove_row(*victim->key());
		}
	}
	//--AgentGen END
}

void nlmLogVariableEntry::row_init(MibTableRow* row, const Oidx& index, MibTable* src)
{
	// shut up compiler about unused parameter(s)
	(void)row;
	(void)index;
	(void)src;
	// The row 'row' with 'index' has been intialized.

	//--AgentGen BEGIN=nlmLogVariableEntry::row_init
	//--AgentGen END
}



void nlmLogVariableEntry::set_row(MibTableRow* r, const char* p0, long p1, unsigned long p2, unsigned long p3, unsigned long p4, long p5, const OctetStr& p6, const char* p7, const char* p8, unsigned long p9hi, unsigned long p9lo
		, const OctetStr& p10)
{
	r->get_nth(0)->replace_value(new Oid(p0));
	r->get_nth(1)->replace_value(new SnmpInt32(p1));
	r->get_nth(2)->replace_value(new Counter32(p2));
	r->get_nth(3)->replace_value(new Gauge32(p3));
	r->get_nth(4)->replace_value(new TimeTicks(p4));
	r->get_nth(5)->replace_value(new SnmpInt32(p5));
	r->get_nth(6)->replace_value(new OctetStr(p6));
	r->get_nth(7)->replace_value(new IpAddress(p7));
	r->get_nth(8)->replace_value(new Oid(p8));
	r->get_nth(9)->replace_value(new Counter64(p9hi, p9lo));
	r->get_nth(10)->replace_value(new OpaqueStr(p10));
}


//--AgentGen BEGIN=nlmLogVariableEntry
void nlmLogVariableEntry::add_variable(const Oidx& index,
				       unsigned int i,
				       const Vbx& vb)
{
	Oidx newIndex(index);
	newIndex += (unsigned long)i;
	MibTableRow* r = add_row(newIndex);
	for (int j=nNlmLogVariableCounter32Val; j<r->size(); j++) {
		r->get_nth(j)->set_access(NOACCESS);
	}
	r->get_nth(nNlmLogVariableID)->
	  set_value(vb.get_oid());

	switch (vb.get_syntax()) {
	case sNMP_SYNTAX_INT32:
		r->get_nth(nNlmLogVariableInteger32Val)->
		  replace_value(vb.clone_value());
		r->get_nth(nNlmLogVariableInteger32Val)->
		  set_access(READONLY);
		r->get_nth(nNlmLogVariableValueType)->
		  set_value(4);
		break;
	case sNMP_SYNTAX_TIMETICKS:
		r->get_nth(nNlmLogVariableTimeTicksVal)->
		  replace_value(vb.clone_value());
		r->get_nth(nNlmLogVariableTimeTicksVal)->
		  set_access(READONLY);
		r->get_nth(nNlmLogVariableValueType)->
		  set_value(3);
		break;
	case sNMP_SYNTAX_CNTR32:
		r->get_nth(nNlmLogVariableCounter32Val)->
		  replace_value(vb.clone_value());
		r->get_nth(nNlmLogVariableCounter32Val)->
		  set_access(READONLY);
		r->get_nth(nNlmLogVariableValueType)->
		  set_value(1);
		break;
	case sNMP_SYNTAX_GAUGE32:
		r->get_nth(nNlmLogVariableUnsigned32Val)->
		  replace_value(vb.clone_value());
		r->get_nth(nNlmLogVariableUnsigned32Val)->
		  set_access(READONLY);
		r->get_nth(nNlmLogVariableValueType)->
		  set_value(2);
		break;
	case sNMP_SYNTAX_CNTR64:
		r->get_nth(nNlmLogVariableCounter64Val)->
		  replace_value(vb.clone_value());
		r->get_nth(nNlmLogVariableCounter64Val)->
		  set_access(READONLY);
		r->get_nth(nNlmLogVariableValueType)->
		  set_value(8);
		break;
	case sNMP_SYNTAX_OCTETS:
	case sNMP_SYNTAX_BITS:
		r->get_nth(nNlmLogVariableOctetStringVal)->
		  replace_value(vb.clone_value());
		r->get_nth(nNlmLogVariableOctetStringVal)->
		  set_access(READONLY);
		r->get_nth(nNlmLogVariableValueType)->
		  set_value(6);
		break;
	case sNMP_SYNTAX_OPAQUE: {
		OpaqueStr* opaque = new OpaqueStr();
		vb.get_value(*opaque);
		r->get_nth(nNlmLogVariableOpaqueVal)->
		  replace_value(opaque);
		r->get_nth(nNlmLogVariableOpaqueVal)->
		  set_access(READONLY);
		r->get_nth(nNlmLogVariableValueType)->
		  set_value(9);
		break;
	}
	case sNMP_SYNTAX_IPADDR:
		r->get_nth(nNlmLogVariableIpAddressVal)->
		  replace_value(vb.clone_value());
		r->get_nth(nNlmLogVariableIpAddressVal)->
		  set_access(READONLY);
		r->get_nth(nNlmLogVariableValueType)->
		  set_value(5);
		break;
	case sNMP_SYNTAX_OID:
		r->get_nth(nNlmLogVariableOidVal)->
		  replace_value(vb.clone_value());
		r->get_nth(nNlmLogVariableOidVal)->
		  set_access(READONLY);
		r->get_nth(nNlmLogVariableValueType)->
		  set_value(7);
		break;
	case sNMP_SYNTAX_NULL:
		break;
	}
}
//--AgentGen END




notification_log_mib::notification_log_mib():
   MibGroup("1.3.6.1.2.1.92", "notificationLogMIB")
{

	//--AgentGen BEGIN=notification_log_mib::notification_log_mib
	//--AgentGen END
	add(new nlmConfigGlobalEntryLimit());
	add(new nlmConfigGlobalAgeOut());
	add(new nlmConfigLogEntry());
	add(new nlmStatsGlobalNotificationsLogged());
	add(new nlmStatsGlobalNotificationsBumped());
	add(new nlmStatsLogEntry());
	add(new nlmLogEntry());
	add(new nlmLogVariableEntry());

	//--AgentGen BEGIN=notification_log_mib::notification_log_mib:post
	/*
	if (!nlmConfigLogEntry::instance->find_index("0")) {
		MibTableRow* r = nlmConfigLogEntry::instance->add_row("0");
		r->get_nth(nNlmConfigLogEntryStatus)->set_access(READONLY);
		nlmConfigLogEntry::instance->set_row(r, OctetStr(""),
						     50, 1, 1, 4, 1);
	}
	*/
	//--AgentGen END
}


//--AgentGen BEGIN=notification_log_mib
//--AgentGen END



//--AgentGen BEGIN=_END
#ifdef AGENTPP_NAMESPACE
}
#endif
#endif
//--AgentGen END
