/*_############################################################################
  _## 
  _##  mib_complex_entry.cpp  
  _## 
  _##
  _##  AGENT++ API Version 3.5.31
  _##  -----------------------------------------------
  _##  Copyright (C) 2000-2010 Frank Fock, Jochen Katz
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##  WHEREAS,  Frank  Fock  and  Jochen  Katz  are  the  owners of valuable
  _##  intellectual  property rights relating to  the AGENT++ API and wish to
  _##  license AGENT++ subject to the  terms and conditions set forth  below;
  _##  and
  _##
  _##  WHEREAS, you ("Licensee") acknowledge  that Frank Fock and Jochen Katz
  _##  have the right  to grant licenses  to the intellectual property rights
  _##  relating to  AGENT++, and that you desire  to obtain a license  to use
  _##  AGENT++ subject to the terms and conditions set forth below;
  _##
  _##  Frank  Fock    and Jochen   Katz   grants  Licensee  a  non-exclusive,
  _##  non-transferable, royalty-free  license  to use   AGENT++ and  related
  _##  materials without  charge provided the Licensee  adheres to all of the
  _##  terms and conditions of this Agreement.
  _##
  _##  By downloading, using, or  copying  AGENT++  or any  portion  thereof,
  _##  Licensee  agrees to abide  by  the intellectual property  laws and all
  _##  other   applicable laws  of  Germany,  and  to all of   the  terms and
  _##  conditions  of this Agreement, and agrees  to take all necessary steps
  _##  to  ensure that the  terms and  conditions of  this Agreement are  not
  _##  violated  by any person  or entity under the  Licensee's control or in
  _##  the Licensee's service.
  _##
  _##  Licensee shall maintain  the  copyright and trademark  notices  on the
  _##  materials  within or otherwise  related   to AGENT++, and  not  alter,
  _##  erase, deface or overprint any such notice.
  _##
  _##  Except  as specifically   provided in  this  Agreement,   Licensee  is
  _##  expressly   prohibited  from  copying,   merging,  selling,   leasing,
  _##  assigning,  or  transferring  in  any manner,  AGENT++ or  any portion
  _##  thereof.
  _##
  _##  Licensee may copy materials   within or otherwise related   to AGENT++
  _##  that bear the author's copyright only  as required for backup purposes
  _##  or for use solely by the Licensee.
  _##
  _##  Licensee may  not distribute  in any  form  of electronic  or  printed
  _##  communication the  materials  within or  otherwise  related to AGENT++
  _##  that  bear the author's  copyright, including  but  not limited to the
  _##  source   code, documentation,  help  files, examples,  and benchmarks,
  _##  without prior written consent from the authors.  Send any requests for
  _##  limited distribution rights to fock@agentpp.com.
  _##
  _##  Licensee  hereby  grants  a  royalty-free  license  to  any  and   all 
  _##  derivatives  based  upon this software  code base,  that  may  be used
  _##  as a SNMP  agent development  environment or a  SNMP agent development 
  _##  tool.
  _##
  _##  Licensee may  modify  the sources  of AGENT++ for  the Licensee's  own
  _##  purposes.  Thus, Licensee  may  not  distribute  modified  sources  of
  _##  AGENT++ without prior written consent from the authors. 
  _##
  _##  The Licensee may distribute  binaries derived from or contained within
  _##  AGENT++ provided that:
  _##
  _##  1) The Binaries are  not integrated,  bundled,  combined, or otherwise
  _##     associated with a SNMP agent development environment or  SNMP agent
  _##     development tool; and
  _##
  _##  2) The Binaries are not a documented part of any distribution material. 
  _##
  _##
  _##  THIS  SOFTWARE  IS  PROVIDED ``AS  IS''  AND  ANY  EXPRESS OR  IMPLIED
  _##  WARRANTIES, INCLUDING, BUT NOT LIMITED  TO, THE IMPLIED WARRANTIES  OF
  _##  MERCHANTABILITY AND FITNESS FOR  A PARTICULAR PURPOSE  ARE DISCLAIMED.
  _##  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
  _##  INDIRECT,   INCIDENTAL,  SPECIAL, EXEMPLARY,  OR CONSEQUENTIAL DAMAGES
  _##  (INCLUDING,  BUT NOT LIMITED  TO,  PROCUREMENT OF SUBSTITUTE  GOODS OR
  _##  SERVICES; LOSS OF  USE,  DATA, OR PROFITS; OR  BUSINESS  INTERRUPTION)
  _##  HOWEVER CAUSED  AND ON ANY THEORY  OF  LIABILITY, WHETHER IN CONTRACT,
  _##  STRICT LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
  _##  IN  ANY WAY OUT OF  THE USE OF THIS  SOFTWARE,  EVEN IF ADVISED OF THE
  _##  POSSIBILITY OF SUCH DAMAGE. 
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:07:56 CEST 2010 
  _##  
  _##########################################################################*/
#include <libagent.h>

#include <agent_pp/mib_complex_entry.h>

using namespace std;

#ifdef AGENTPP_NAMESPACE
namespace Agentpp {
#endif

/*------------------------ class MibComplexEntry ------------------------*/

/*------------------------ class MibStaticEntry ------------------------*/

/*------------------------ class MibStaticTable ------------------------*/

void MibStaticTable::add(const MibStaticEntry& entry) 
{
        ThreadSynchronize guard(*this);
#ifdef AGENTPP_USE_STL
	// TODO: added here for backward compatibility, should be removed
	// later
        if( oid.is_root_of( entry.get_oid() ) )
        {
            Vbx tmpvb( entry );
            Oidx tmpoid( entry.get_oid().cut_left( oid.len() ) );
            tmpvb.set_oid( tmpoid );
            insert_or_update( MibStaticEntry( tmpvb ) );
        }
        else
        {
            insert_or_update( entry );
        }
#else
	Oidx tmpoid(entry.get_oid());
	MibStaticEntry* newEntry = new MibStaticEntry(entry);
	// TODO: added here for backward compatibility, should be removed
	// later
	if (oid.is_root_of(tmpoid)) {
		tmpoid = tmpoid.cut_left(oid.len());
		newEntry->set_oid(tmpoid);
	}
	MibStaticEntry* ptr = contents.find(&tmpoid);
	if (ptr) {
		contents.remove(&tmpoid);
	}
	contents.add(newEntry);
#endif
}

void MibStaticTable::remove(const Oidx& o) 
{
        ThreadSynchronize guard(*this);
#ifdef AGENTPP_USE_STL
        Vbx tmpvb;
        if( oid.is_root_of( o ) )
        {
            Oidx tmpoid( o.cut_left( oid.len() ) );
            tmpvb.set_oid( tmpoid );
        }
        else
        {
            tmpvb.set_oid( o );
        }
        set<MibStaticEntry>::iterator i = contents.find( tmpvb );
        if( i != contents.end() )
            contents.erase( i );
#else
	Oidx tmpoid(o);
	if (oid.is_root_of(tmpoid)) {
		tmpoid = tmpoid.cut_left(oid.len());
		contents.remove(&tmpoid);
	}
#endif
}

MibStaticEntry* MibStaticTable::get(const Oidx& o, bool suffixOnly) 
{
#ifdef AGENTPP_USE_STL
        MibStaticEntry *rc = 0;
        Vbx tmpvb;
        ThreadSynchronize guard(*this);
        if( !suffixOnly || oid.is_root_of( o ) )
        {
            Oidx tmpoid( o.cut_left( oid.len() ) );
            tmpvb.set_oid( tmpoid );
        }
        else
        {
            tmpvb.set_oid( o );
        }
        set<MibStaticEntry>::iterator i = contents.find( tmpvb );
        if( i != contents.end() )
        {
            rc = &(const_cast<MibStaticEntry &>(*i));
        }

        return rc;
#else
	Oidx tmpoid(o);
	if (!suffixOnly) {
		if (!oid.is_root_of(tmpoid))
			return 0;
		tmpoid = tmpoid.cut_left(oid.len());
	}
	return contents.find(&tmpoid);
#endif
}

Oidx MibStaticTable::find_succ(const Oidx& o, Request*)
{
        ThreadSynchronize guard(*this);
#ifdef AGENTPP_USE_STL
        Oidx rc;
	set<MibStaticEntry>::iterator i;
	if( o <= oid )
	{
	    i = contents.begin();
	}
        else
	{
	    Vbx tmpvb;
	    if( oid.is_root_of( o ) )
	    {
		Oidx tmpoid( o.cut_left( oid.len() ) );
		tmpvb.set_oid( tmpoid );
	    }
	    else
	    {
		tmpvb.set_oid( o );
	    }
	    i = contents.upper_bound( tmpvb );
	}

        if( i != contents.end() )
        {
            rc = oid;
            rc += i->get_oid();
        }

        return rc;
#else
	Oidx tmpoid(o);
	Oidx retval;
	if (tmpoid <= oid) {
		tmpoid = Oidx();
	}
	else if (tmpoid.len() >= oid.len()) {
		tmpoid = tmpoid.cut_left(oid.len());
	}
	else {
		return retval;
	}
	MibStaticEntry* ptr = contents.find_upper(&tmpoid);
	if ((ptr) && (*ptr->key() == tmpoid)) {
		ptr = contents.find_next(&tmpoid);
	}
	if (ptr) {
		retval = oid;
		retval += ptr->get_oid();
	}
	return retval;
#endif
}

void MibStaticTable::get_request(Request* req, int ind)
{
	Oidx tmpoid(req->get_oid(ind));

	if (oid.is_root_of(tmpoid)) {
		tmpoid = tmpoid.cut_left(oid.len());
	}
	else {
		Vbx vb(req->get_oid(ind));
		vb.set_syntax(sNMP_SYNTAX_NOSUCHOBJECT);
		// error status (v1) will be set by RequestList
		req->finish(ind, vb); 
		return;
	}

        ThreadSynchronize guard(*this);
#ifdef AGENTPP_USE_STL
        set<MibStaticEntry>::iterator entry = contents.find( Vbx( tmpoid ) );
        if( entry == contents.end() )
#else
	MibStaticEntry* entry = contents.find(&tmpoid);
	if (!entry)
#endif
        {
		Vbx vb(req->get_oid(ind));
		// TODO: This error status is just a guess, we cannot
		// determine exactly whether it is a noSuchInstance or
		// noSuchObject. May be a subclass could do a better 
		// job by knowing more details from the MIB structure?
		if (tmpoid.len() == 0) {
			vb.set_syntax(sNMP_SYNTAX_NOSUCHOBJECT);
		}
		else {
#if 0
			Oidx columnID;
			columnID = tmpoid[0];
			entry = contents.find_upper(&columnID);
			if (entry)
#endif
				vb.set_syntax(sNMP_SYNTAX_NOSUCHINSTANCE);
#if 0
			else
				vb.set_syntax(sNMP_SYNTAX_NOSUCHOBJECT);
#endif
		}
		// error status (v1) will be set by RequestList
		req->finish(ind, vb); 
	}
	else {
		Oidx id(oid);
		id += entry->get_oid();
		Vbx vb(*entry);
		vb.set_oid(id);
		req->finish(ind, vb);
	}
}

void MibStaticTable::get_next_request(Request* req, int ind)
{
	Oidx tmpoid(req->get_oid(ind));

	if (oid.is_root_of(tmpoid)) {
		tmpoid = tmpoid.cut_left(oid.len());
	}
	else {
		Vbx vb(req->get_oid(ind));
		vb.set_syntax(sNMP_SYNTAX_NOSUCHOBJECT);
		// error status (v1) will be set by RequestList
		req->finish(ind, vb); 
	}
        ThreadSynchronize guard(*this);
#ifdef AGENTPP_USE_STL
        set<MibStaticEntry>::iterator entry = contents.find( Vbx( tmpoid ) );
        if( entry == contents.end() )
#else
	MibStaticEntry* entry = contents.find_upper(&tmpoid);
	if (!entry)
#endif
        {
		Vbx vb(req->get_oid(ind));
		// TODO: This error status is just a guess, we cannot
		// determine exactly whether it is a noSuchInstance or
		// noSuchObject. May be a subclass could do a better 
		// job by knowing more details from the MIB structure?
		vb.set_syntax(sNMP_SYNTAX_NOSUCHINSTANCE);
		// error status (v1) will be set by RequestList
		req->finish(ind, vb); 
	}
	else {
		Oidx id(oid);
		id += entry->get_oid();
		Vbx vb(*entry);
		vb.set_oid(id);
		req->finish(ind, vb);
	}
}

#ifdef AGENTPP_NAMESPACE
}
#endif

