/*_############################################################################
  _## 
  _##  atm_mib.cpp  
  _## 
  _##
  _##  AGENT++ API Version 3.5.31
  _##  -----------------------------------------------
  _##  Copyright (C) 2000-2010 Frank Fock, Jochen Katz
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##  WHEREAS,  Frank  Fock  and  Jochen  Katz  are  the  owners of valuable
  _##  intellectual  property rights relating to  the AGENT++ API and wish to
  _##  license AGENT++ subject to the  terms and conditions set forth  below;
  _##  and
  _##
  _##  WHEREAS, you ("Licensee") acknowledge  that Frank Fock and Jochen Katz
  _##  have the right  to grant licenses  to the intellectual property rights
  _##  relating to  AGENT++, and that you desire  to obtain a license  to use
  _##  AGENT++ subject to the terms and conditions set forth below;
  _##
  _##  Frank  Fock    and Jochen   Katz   grants  Licensee  a  non-exclusive,
  _##  non-transferable, royalty-free  license  to use   AGENT++ and  related
  _##  materials without  charge provided the Licensee  adheres to all of the
  _##  terms and conditions of this Agreement.
  _##
  _##  By downloading, using, or  copying  AGENT++  or any  portion  thereof,
  _##  Licensee  agrees to abide  by  the intellectual property  laws and all
  _##  other   applicable laws  of  Germany,  and  to all of   the  terms and
  _##  conditions  of this Agreement, and agrees  to take all necessary steps
  _##  to  ensure that the  terms and  conditions of  this Agreement are  not
  _##  violated  by any person  or entity under the  Licensee's control or in
  _##  the Licensee's service.
  _##
  _##  Licensee shall maintain  the  copyright and trademark  notices  on the
  _##  materials  within or otherwise  related   to AGENT++, and  not  alter,
  _##  erase, deface or overprint any such notice.
  _##
  _##  Except  as specifically   provided in  this  Agreement,   Licensee  is
  _##  expressly   prohibited  from  copying,   merging,  selling,   leasing,
  _##  assigning,  or  transferring  in  any manner,  AGENT++ or  any portion
  _##  thereof.
  _##
  _##  Licensee may copy materials   within or otherwise related   to AGENT++
  _##  that bear the author's copyright only  as required for backup purposes
  _##  or for use solely by the Licensee.
  _##
  _##  Licensee may  not distribute  in any  form  of electronic  or  printed
  _##  communication the  materials  within or  otherwise  related to AGENT++
  _##  that  bear the author's  copyright, including  but  not limited to the
  _##  source   code, documentation,  help  files, examples,  and benchmarks,
  _##  without prior written consent from the authors.  Send any requests for
  _##  limited distribution rights to fock@agentpp.com.
  _##
  _##  Licensee  hereby  grants  a  royalty-free  license  to  any  and   all 
  _##  derivatives  based  upon this software  code base,  that  may  be used
  _##  as a SNMP  agent development  environment or a  SNMP agent development 
  _##  tool.
  _##
  _##  Licensee may  modify  the sources  of AGENT++ for  the Licensee's  own
  _##  purposes.  Thus, Licensee  may  not  distribute  modified  sources  of
  _##  AGENT++ without prior written consent from the authors. 
  _##
  _##  The Licensee may distribute  binaries derived from or contained within
  _##  AGENT++ provided that:
  _##
  _##  1) The Binaries are  not integrated,  bundled,  combined, or otherwise
  _##     associated with a SNMP agent development environment or  SNMP agent
  _##     development tool; and
  _##
  _##  2) The Binaries are not a documented part of any distribution material. 
  _##
  _##
  _##  THIS  SOFTWARE  IS  PROVIDED ``AS  IS''  AND  ANY  EXPRESS OR  IMPLIED
  _##  WARRANTIES, INCLUDING, BUT NOT LIMITED  TO, THE IMPLIED WARRANTIES  OF
  _##  MERCHANTABILITY AND FITNESS FOR  A PARTICULAR PURPOSE  ARE DISCLAIMED.
  _##  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
  _##  INDIRECT,   INCIDENTAL,  SPECIAL, EXEMPLARY,  OR CONSEQUENTIAL DAMAGES
  _##  (INCLUDING,  BUT NOT LIMITED  TO,  PROCUREMENT OF SUBSTITUTE  GOODS OR
  _##  SERVICES; LOSS OF  USE,  DATA, OR PROFITS; OR  BUSINESS  INTERRUPTION)
  _##  HOWEVER CAUSED  AND ON ANY THEORY  OF  LIABILITY, WHETHER IN CONTRACT,
  _##  STRICT LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
  _##  IN  ANY WAY OUT OF  THE USE OF THIS  SOFTWARE,  EVEN IF ADVISED OF THE
  _##  POSSIBILITY OF SUCH DAMAGE. 
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:07:56 CEST 2010 
  _##  
  _##########################################################################*/


#include <atm_mib.h>



/**
 *  generated by AgentGen 1.3.5 for AGENT++v3.4 with simulation extensions 
 * Tue Apr 18 02:03:56 GMT+04:30 2000.
 */

#ifdef SNMP_PP_NAMESPACE
using namespace Snmp_pp;
#endif

#ifdef AGENTPP_NAMESPACE
namespace Agentpp {
#endif


/**
 *  atmInterfaceMaxVpcs
 *
 */

atmInterfaceMaxVpcs::atmInterfaceMaxVpcs(const Oidx& id):
   SimMibLeaf(id, READWRITE, new SnmpInt32())
{

}

atmInterfaceMaxVpcs::~atmInterfaceMaxVpcs()
{
}

MibEntryPtr atmInterfaceMaxVpcs::clone()
{
	MibEntryPtr other = new atmInterfaceMaxVpcs(oid);
	((atmInterfaceMaxVpcs*)other)->replace_value(value->clone());
	((atmInterfaceMaxVpcs*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmInterfaceMaxVpcs::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 4096))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmInterfaceMaxVpcs::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmInterfaceMaxVccs
 *
 */

atmInterfaceMaxVccs::atmInterfaceMaxVccs(const Oidx& id):
   SimMibLeaf(id, READWRITE, new SnmpInt32())
{

}

atmInterfaceMaxVccs::~atmInterfaceMaxVccs()
{
}

MibEntryPtr atmInterfaceMaxVccs::clone()
{
	MibEntryPtr other = new atmInterfaceMaxVccs(oid);
	((atmInterfaceMaxVccs*)other)->replace_value(value->clone());
	((atmInterfaceMaxVccs*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmInterfaceMaxVccs::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 65536))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmInterfaceMaxVccs::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmInterfaceConfVpcs
 *
 */

atmInterfaceConfVpcs::atmInterfaceConfVpcs(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmInterfaceConfVpcs::~atmInterfaceConfVpcs()
{
}

MibEntryPtr atmInterfaceConfVpcs::clone()
{
	MibEntryPtr other = new atmInterfaceConfVpcs(oid);
	((atmInterfaceConfVpcs*)other)->replace_value(value->clone());
	((atmInterfaceConfVpcs*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceConfVccs
 *
 */

atmInterfaceConfVccs::atmInterfaceConfVccs(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmInterfaceConfVccs::~atmInterfaceConfVccs()
{
}

MibEntryPtr atmInterfaceConfVccs::clone()
{
	MibEntryPtr other = new atmInterfaceConfVccs(oid);
	((atmInterfaceConfVccs*)other)->replace_value(value->clone());
	((atmInterfaceConfVccs*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceMaxActiveVpiBits
 *
 */

atmInterfaceMaxActiveVpiBits::atmInterfaceMaxActiveVpiBits(const Oidx& id):
   SimMibLeaf(id, READWRITE, new SnmpInt32())
{

}

atmInterfaceMaxActiveVpiBits::~atmInterfaceMaxActiveVpiBits()
{
}

MibEntryPtr atmInterfaceMaxActiveVpiBits::clone()
{
	MibEntryPtr other = new atmInterfaceMaxActiveVpiBits(oid);
	((atmInterfaceMaxActiveVpiBits*)other)->replace_value(value->clone());
	((atmInterfaceMaxActiveVpiBits*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmInterfaceMaxActiveVpiBits::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 12))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmInterfaceMaxActiveVpiBits::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmInterfaceMaxActiveVciBits
 *
 */

atmInterfaceMaxActiveVciBits::atmInterfaceMaxActiveVciBits(const Oidx& id):
   SimMibLeaf(id, READWRITE, new SnmpInt32())
{

}

atmInterfaceMaxActiveVciBits::~atmInterfaceMaxActiveVciBits()
{
}

MibEntryPtr atmInterfaceMaxActiveVciBits::clone()
{
	MibEntryPtr other = new atmInterfaceMaxActiveVciBits(oid);
	((atmInterfaceMaxActiveVciBits*)other)->replace_value(value->clone());
	((atmInterfaceMaxActiveVciBits*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmInterfaceMaxActiveVciBits::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 16))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmInterfaceMaxActiveVciBits::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmInterfaceIlmiVpi
 *
 */

atmInterfaceIlmiVpi::atmInterfaceIlmiVpi(const Oidx& id):
   SimMibLeaf(id, READWRITE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmInterfaceIlmiVpi::~atmInterfaceIlmiVpi()
{
}

MibEntryPtr atmInterfaceIlmiVpi::clone()
{
	MibEntryPtr other = new atmInterfaceIlmiVpi(oid);
	((atmInterfaceIlmiVpi*)other)->replace_value(value->clone());
	((atmInterfaceIlmiVpi*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmInterfaceIlmiVpi::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 4095))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmInterfaceIlmiVpi::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmInterfaceIlmiVci
 *
 */

atmInterfaceIlmiVci::atmInterfaceIlmiVci(const Oidx& id):
   SimMibLeaf(id, READWRITE, new SnmpInt32(16), VMODE_DEFAULT)
{

}

atmInterfaceIlmiVci::~atmInterfaceIlmiVci()
{
}

MibEntryPtr atmInterfaceIlmiVci::clone()
{
	MibEntryPtr other = new atmInterfaceIlmiVci(oid);
	((atmInterfaceIlmiVci*)other)->replace_value(value->clone());
	((atmInterfaceIlmiVci*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmInterfaceIlmiVci::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 65535))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmInterfaceIlmiVci::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmInterfaceAddressType
 *
 */

atmInterfaceAddressType::atmInterfaceAddressType(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmInterfaceAddressType::~atmInterfaceAddressType()
{
}

MibEntryPtr atmInterfaceAddressType::clone()
{
	MibEntryPtr other = new atmInterfaceAddressType(oid);
	((atmInterfaceAddressType*)other)->replace_value(value->clone());
	((atmInterfaceAddressType*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceAdminAddress
 *
 */

atmInterfaceAdminAddress::atmInterfaceAdminAddress(const Oidx& id):
   SimMibLeaf(id, READONLY, new OctetStr())
{

}

atmInterfaceAdminAddress::~atmInterfaceAdminAddress()
{
}

MibEntryPtr atmInterfaceAdminAddress::clone()
{
	MibEntryPtr other = new atmInterfaceAdminAddress(oid);
	((atmInterfaceAdminAddress*)other)->replace_value(value->clone());
	((atmInterfaceAdminAddress*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceMyNeighborIpAddress
 *
 */

atmInterfaceMyNeighborIpAddress::atmInterfaceMyNeighborIpAddress(const Oidx& id):
   SimMibLeaf(id, READWRITE, new IpAddress("0.0.0.0"))
{

}

atmInterfaceMyNeighborIpAddress::~atmInterfaceMyNeighborIpAddress()
{
}

MibEntryPtr atmInterfaceMyNeighborIpAddress::clone()
{
	MibEntryPtr other = new atmInterfaceMyNeighborIpAddress(oid);
	((atmInterfaceMyNeighborIpAddress*)other)->replace_value(value->clone());
	((atmInterfaceMyNeighborIpAddress*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmInterfaceMyNeighborIpAddress::value_ok(const Vbx& vb)
{
	// place code to check validity of new values here
	return TRUE;
}

int atmInterfaceMyNeighborIpAddress::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmInterfaceMyNeighborIfName
 *
 */

atmInterfaceMyNeighborIfName::atmInterfaceMyNeighborIfName(const Oidx& id):
   SimMibLeaf(id, READWRITE, new OctetStr())
{

}

atmInterfaceMyNeighborIfName::~atmInterfaceMyNeighborIfName()
{
}

MibEntryPtr atmInterfaceMyNeighborIfName::clone()
{
	MibEntryPtr other = new atmInterfaceMyNeighborIfName(oid);
	((atmInterfaceMyNeighborIfName*)other)->replace_value(value->clone());
	((atmInterfaceMyNeighborIfName*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmInterfaceMyNeighborIfName::value_ok(const Vbx& vb)
{
	// place code to check validity of new values here
	return TRUE;
}

int atmInterfaceMyNeighborIfName::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	Vb vb(req->get_value(ind));
	OctetStr v;
	vb.get_value(v);
	if (!(((v.len() >= 0) && (v.len() <= 255))))
		 return SNMP_ERROR_WRONG_LENGTH;
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmInterfaceCurrentMaxVpiBits
 *
 */

atmInterfaceCurrentMaxVpiBits::atmInterfaceCurrentMaxVpiBits(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmInterfaceCurrentMaxVpiBits::~atmInterfaceCurrentMaxVpiBits()
{
}

MibEntryPtr atmInterfaceCurrentMaxVpiBits::clone()
{
	MibEntryPtr other = new atmInterfaceCurrentMaxVpiBits(oid);
	((atmInterfaceCurrentMaxVpiBits*)other)->replace_value(value->clone());
	((atmInterfaceCurrentMaxVpiBits*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceCurrentMaxVciBits
 *
 */

atmInterfaceCurrentMaxVciBits::atmInterfaceCurrentMaxVciBits(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmInterfaceCurrentMaxVciBits::~atmInterfaceCurrentMaxVciBits()
{
}

MibEntryPtr atmInterfaceCurrentMaxVciBits::clone()
{
	MibEntryPtr other = new atmInterfaceCurrentMaxVciBits(oid);
	((atmInterfaceCurrentMaxVciBits*)other)->replace_value(value->clone());
	((atmInterfaceCurrentMaxVciBits*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceSubscrAddress
 *
 */

atmInterfaceSubscrAddress::atmInterfaceSubscrAddress(const Oidx& id):
   SimMibLeaf(id, READWRITE, new OctetStr())
{

}

atmInterfaceSubscrAddress::~atmInterfaceSubscrAddress()
{
}

MibEntryPtr atmInterfaceSubscrAddress::clone()
{
	MibEntryPtr other = new atmInterfaceSubscrAddress(oid);
	((atmInterfaceSubscrAddress*)other)->replace_value(value->clone());
	((atmInterfaceSubscrAddress*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmInterfaceSubscrAddress::value_ok(const Vbx& vb)
{
	// place code to check validity of new values here
	return TRUE;
}

int atmInterfaceSubscrAddress::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	Vb vb(req->get_value(ind));
	OctetStr v;
	vb.get_value(v);
	if (!(((v.len() >= 0) && (v.len() <= 40))))
		 return SNMP_ERROR_WRONG_LENGTH;
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmInterfaceDs3PlcpSEFSs
 *
 */

atmInterfaceDs3PlcpSEFSs::atmInterfaceDs3PlcpSEFSs(const Oidx& id):
   SimMibLeaf(id, READONLY, new Counter32())
{

}

atmInterfaceDs3PlcpSEFSs::~atmInterfaceDs3PlcpSEFSs()
{
}

MibEntryPtr atmInterfaceDs3PlcpSEFSs::clone()
{
	MibEntryPtr other = new atmInterfaceDs3PlcpSEFSs(oid);
	((atmInterfaceDs3PlcpSEFSs*)other)->replace_value(value->clone());
	((atmInterfaceDs3PlcpSEFSs*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceDs3PlcpAlarmState
 *
 */

atmInterfaceDs3PlcpAlarmState::atmInterfaceDs3PlcpAlarmState(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmInterfaceDs3PlcpAlarmState::~atmInterfaceDs3PlcpAlarmState()
{
}

MibEntryPtr atmInterfaceDs3PlcpAlarmState::clone()
{
	MibEntryPtr other = new atmInterfaceDs3PlcpAlarmState(oid);
	((atmInterfaceDs3PlcpAlarmState*)other)->replace_value(value->clone());
	((atmInterfaceDs3PlcpAlarmState*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceDs3PlcpUASs
 *
 */

atmInterfaceDs3PlcpUASs::atmInterfaceDs3PlcpUASs(const Oidx& id):
   SimMibLeaf(id, READONLY, new Counter32())
{

}

atmInterfaceDs3PlcpUASs::~atmInterfaceDs3PlcpUASs()
{
}

MibEntryPtr atmInterfaceDs3PlcpUASs::clone()
{
	MibEntryPtr other = new atmInterfaceDs3PlcpUASs(oid);
	((atmInterfaceDs3PlcpUASs*)other)->replace_value(value->clone());
	((atmInterfaceDs3PlcpUASs*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceOCDEvents
 *
 */

atmInterfaceOCDEvents::atmInterfaceOCDEvents(const Oidx& id):
   SimMibLeaf(id, READONLY, new Counter32())
{

}

atmInterfaceOCDEvents::~atmInterfaceOCDEvents()
{
}

MibEntryPtr atmInterfaceOCDEvents::clone()
{
	MibEntryPtr other = new atmInterfaceOCDEvents(oid);
	((atmInterfaceOCDEvents*)other)->replace_value(value->clone());
	((atmInterfaceOCDEvents*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmInterfaceTCAlarmState
 *
 */

atmInterfaceTCAlarmState::atmInterfaceTCAlarmState(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmInterfaceTCAlarmState::~atmInterfaceTCAlarmState()
{
}

MibEntryPtr atmInterfaceTCAlarmState::clone()
{
	MibEntryPtr other = new atmInterfaceTCAlarmState(oid);
	((atmInterfaceTCAlarmState*)other)->replace_value(value->clone());
	((atmInterfaceTCAlarmState*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmTrafficDescrType
 *
 */

atmTrafficDescrType::atmTrafficDescrType(const Oidx& id):
   SimMibLeaf(id, READCREATE, new Oid("atmNoClpNoScr"), VMODE_DEFAULT)
{

}

atmTrafficDescrType::~atmTrafficDescrType()
{
}

MibEntryPtr atmTrafficDescrType::clone()
{
	MibEntryPtr other = new atmTrafficDescrType(oid);
	((atmTrafficDescrType*)other)->replace_value(value->clone());
	((atmTrafficDescrType*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmTrafficDescrType::value_ok(const Vbx& vb)
{
	// place code to check validity of new values here
	return TRUE;
}

int atmTrafficDescrType::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmTrafficDescrParam1
 *
 */

atmTrafficDescrParam1::atmTrafficDescrParam1(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmTrafficDescrParam1::~atmTrafficDescrParam1()
{
}

MibEntryPtr atmTrafficDescrParam1::clone()
{
	MibEntryPtr other = new atmTrafficDescrParam1(oid);
	((atmTrafficDescrParam1*)other)->replace_value(value->clone());
	((atmTrafficDescrParam1*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmTrafficDescrParam1::value_ok(const Vbx& vb)
{
	// place code to check validity of new values here
	return TRUE;
}

int atmTrafficDescrParam1::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmTrafficDescrParam2
 *
 */

atmTrafficDescrParam2::atmTrafficDescrParam2(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmTrafficDescrParam2::~atmTrafficDescrParam2()
{
}

MibEntryPtr atmTrafficDescrParam2::clone()
{
	MibEntryPtr other = new atmTrafficDescrParam2(oid);
	((atmTrafficDescrParam2*)other)->replace_value(value->clone());
	((atmTrafficDescrParam2*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmTrafficDescrParam2::value_ok(const Vbx& vb)
{
	// place code to check validity of new values here
	return TRUE;
}

int atmTrafficDescrParam2::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmTrafficDescrParam3
 *
 */

atmTrafficDescrParam3::atmTrafficDescrParam3(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmTrafficDescrParam3::~atmTrafficDescrParam3()
{
}

MibEntryPtr atmTrafficDescrParam3::clone()
{
	MibEntryPtr other = new atmTrafficDescrParam3(oid);
	((atmTrafficDescrParam3*)other)->replace_value(value->clone());
	((atmTrafficDescrParam3*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmTrafficDescrParam3::value_ok(const Vbx& vb)
{
	// place code to check validity of new values here
	return TRUE;
}

int atmTrafficDescrParam3::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmTrafficDescrParam4
 *
 */

atmTrafficDescrParam4::atmTrafficDescrParam4(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmTrafficDescrParam4::~atmTrafficDescrParam4()
{
}

MibEntryPtr atmTrafficDescrParam4::clone()
{
	MibEntryPtr other = new atmTrafficDescrParam4(oid);
	((atmTrafficDescrParam4*)other)->replace_value(value->clone());
	((atmTrafficDescrParam4*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmTrafficDescrParam4::value_ok(const Vbx& vb)
{
	// place code to check validity of new values here
	return TRUE;
}

int atmTrafficDescrParam4::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmTrafficDescrParam5
 *
 */

atmTrafficDescrParam5::atmTrafficDescrParam5(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmTrafficDescrParam5::~atmTrafficDescrParam5()
{
}

MibEntryPtr atmTrafficDescrParam5::clone()
{
	MibEntryPtr other = new atmTrafficDescrParam5(oid);
	((atmTrafficDescrParam5*)other)->replace_value(value->clone());
	((atmTrafficDescrParam5*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmTrafficDescrParam5::value_ok(const Vbx& vb)
{
	// place code to check validity of new values here
	return TRUE;
}

int atmTrafficDescrParam5::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmTrafficQoSClass
 *
 */

atmTrafficQoSClass::atmTrafficQoSClass(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmTrafficQoSClass::~atmTrafficQoSClass()
{
}

MibEntryPtr atmTrafficQoSClass::clone()
{
	MibEntryPtr other = new atmTrafficQoSClass(oid);
	((atmTrafficQoSClass*)other)->replace_value(value->clone());
	((atmTrafficQoSClass*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmTrafficQoSClass::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 255))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmTrafficQoSClass::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmTrafficDescrRowStatus
 *
 */

atmTrafficDescrRowStatus::atmTrafficDescrRowStatus(const Oidx& id):
   snmpRowStatus(id, READCREATE)
{

}

atmTrafficDescrRowStatus::~atmTrafficDescrRowStatus()
{
}

MibEntryPtr atmTrafficDescrRowStatus::clone()
{
	MibEntryPtr other = new atmTrafficDescrRowStatus(oid);
	((atmTrafficDescrRowStatus*)other)->replace_value(value->clone());
	((atmTrafficDescrRowStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmServiceCategory
 *
 */

atmServiceCategory::atmServiceCategory(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(6), VMODE_DEFAULT)
{

}

atmServiceCategory::~atmServiceCategory()
{
}

MibEntryPtr atmServiceCategory::clone()
{
	MibEntryPtr other = new atmServiceCategory(oid);
	((atmServiceCategory*)other)->replace_value(value->clone());
	((atmServiceCategory*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmServiceCategory::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2) && (v != 3)
	     && (v != 4) && (v != 5)
	     && (v != 6)) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmServiceCategory::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmTrafficFrameDiscard
 *
 */

atmTrafficFrameDiscard::atmTrafficFrameDiscard(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(1), VMODE_DEFAULT)
{

}

atmTrafficFrameDiscard::~atmTrafficFrameDiscard()
{
}

MibEntryPtr atmTrafficFrameDiscard::clone()
{
	MibEntryPtr other = new atmTrafficFrameDiscard(oid);
	((atmTrafficFrameDiscard*)other)->replace_value(value->clone());
	((atmTrafficFrameDiscard*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmTrafficFrameDiscard::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2)) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmTrafficFrameDiscard::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVplAdminStatus
 *
 */

atmVplAdminStatus::atmVplAdminStatus(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(2), VMODE_DEFAULT)
{

}

atmVplAdminStatus::~atmVplAdminStatus()
{
}

MibEntryPtr atmVplAdminStatus::clone()
{
	MibEntryPtr other = new atmVplAdminStatus(oid);
	((atmVplAdminStatus*)other)->replace_value(value->clone());
	((atmVplAdminStatus*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVplAdminStatus::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2)) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVplAdminStatus::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVplOperStatus
 *
 */

atmVplOperStatus::atmVplOperStatus(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmVplOperStatus::~atmVplOperStatus()
{
}

MibEntryPtr atmVplOperStatus::clone()
{
	MibEntryPtr other = new atmVplOperStatus(oid);
	((atmVplOperStatus*)other)->replace_value(value->clone());
	((atmVplOperStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVplLastChange
 *
 */

atmVplLastChange::atmVplLastChange(const Oidx& id):
   SimMibLeaf(id, READONLY, new TimeTicks())
{

}

atmVplLastChange::~atmVplLastChange()
{
}

MibEntryPtr atmVplLastChange::clone()
{
	MibEntryPtr other = new atmVplLastChange(oid);
	((atmVplLastChange*)other)->replace_value(value->clone());
	((atmVplLastChange*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVplReceiveTrafficDescrIndex
 *
 */

atmVplReceiveTrafficDescrIndex::atmVplReceiveTrafficDescrIndex(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmVplReceiveTrafficDescrIndex::~atmVplReceiveTrafficDescrIndex()
{
}

MibEntryPtr atmVplReceiveTrafficDescrIndex::clone()
{
	MibEntryPtr other = new atmVplReceiveTrafficDescrIndex(oid);
	((atmVplReceiveTrafficDescrIndex*)other)->replace_value(value->clone());
	((atmVplReceiveTrafficDescrIndex*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVplReceiveTrafficDescrIndex::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 2147483647))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVplReceiveTrafficDescrIndex::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVplTransmitTrafficDescrIndex
 *
 */

atmVplTransmitTrafficDescrIndex::atmVplTransmitTrafficDescrIndex(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmVplTransmitTrafficDescrIndex::~atmVplTransmitTrafficDescrIndex()
{
}

MibEntryPtr atmVplTransmitTrafficDescrIndex::clone()
{
	MibEntryPtr other = new atmVplTransmitTrafficDescrIndex(oid);
	((atmVplTransmitTrafficDescrIndex*)other)->replace_value(value->clone());
	((atmVplTransmitTrafficDescrIndex*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVplTransmitTrafficDescrIndex::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 2147483647))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVplTransmitTrafficDescrIndex::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVplCrossConnectIdentifier
 *
 */

atmVplCrossConnectIdentifier::atmVplCrossConnectIdentifier(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmVplCrossConnectIdentifier::~atmVplCrossConnectIdentifier()
{
}

MibEntryPtr atmVplCrossConnectIdentifier::clone()
{
	MibEntryPtr other = new atmVplCrossConnectIdentifier(oid);
	((atmVplCrossConnectIdentifier*)other)->replace_value(value->clone());
	((atmVplCrossConnectIdentifier*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVplRowStatus
 *
 */

atmVplRowStatus::atmVplRowStatus(const Oidx& id):
   snmpRowStatus(id, READCREATE)
{

}

atmVplRowStatus::~atmVplRowStatus()
{
}

MibEntryPtr atmVplRowStatus::clone()
{
	MibEntryPtr other = new atmVplRowStatus(oid);
	((atmVplRowStatus*)other)->replace_value(value->clone());
	((atmVplRowStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVplCastType
 *
 */

atmVplCastType::atmVplCastType(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(1), VMODE_DEFAULT)
{

}

atmVplCastType::~atmVplCastType()
{
}

MibEntryPtr atmVplCastType::clone()
{
	MibEntryPtr other = new atmVplCastType(oid);
	((atmVplCastType*)other)->replace_value(value->clone());
	((atmVplCastType*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVplCastType::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2) && (v != 3)
	    ) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVplCastType::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVplConnKind
 *
 */

atmVplConnKind::atmVplConnKind(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(1), VMODE_DEFAULT)
{

}

atmVplConnKind::~atmVplConnKind()
{
}

MibEntryPtr atmVplConnKind::clone()
{
	MibEntryPtr other = new atmVplConnKind(oid);
	((atmVplConnKind*)other)->replace_value(value->clone());
	((atmVplConnKind*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVplConnKind::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2) && (v != 3)
	     && (v != 4) && (v != 5)
	    ) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVplConnKind::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVclAdminStatus
 *
 */

atmVclAdminStatus::atmVclAdminStatus(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(2), VMODE_DEFAULT)
{

}

atmVclAdminStatus::~atmVclAdminStatus()
{
}

MibEntryPtr atmVclAdminStatus::clone()
{
	MibEntryPtr other = new atmVclAdminStatus(oid);
	((atmVclAdminStatus*)other)->replace_value(value->clone());
	((atmVclAdminStatus*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVclAdminStatus::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2)) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVclAdminStatus::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVclOperStatus
 *
 */

atmVclOperStatus::atmVclOperStatus(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmVclOperStatus::~atmVclOperStatus()
{
}

MibEntryPtr atmVclOperStatus::clone()
{
	MibEntryPtr other = new atmVclOperStatus(oid);
	((atmVclOperStatus*)other)->replace_value(value->clone());
	((atmVclOperStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVclLastChange
 *
 */

atmVclLastChange::atmVclLastChange(const Oidx& id):
   SimMibLeaf(id, READONLY, new TimeTicks())
{

}

atmVclLastChange::~atmVclLastChange()
{
}

MibEntryPtr atmVclLastChange::clone()
{
	MibEntryPtr other = new atmVclLastChange(oid);
	((atmVclLastChange*)other)->replace_value(value->clone());
	((atmVclLastChange*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVclReceiveTrafficDescrIndex
 *
 */

atmVclReceiveTrafficDescrIndex::atmVclReceiveTrafficDescrIndex(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmVclReceiveTrafficDescrIndex::~atmVclReceiveTrafficDescrIndex()
{
}

MibEntryPtr atmVclReceiveTrafficDescrIndex::clone()
{
	MibEntryPtr other = new atmVclReceiveTrafficDescrIndex(oid);
	((atmVclReceiveTrafficDescrIndex*)other)->replace_value(value->clone());
	((atmVclReceiveTrafficDescrIndex*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVclReceiveTrafficDescrIndex::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 2147483647))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVclReceiveTrafficDescrIndex::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVclTransmitTrafficDescrIndex
 *
 */

atmVclTransmitTrafficDescrIndex::atmVclTransmitTrafficDescrIndex(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(0), VMODE_DEFAULT)
{

}

atmVclTransmitTrafficDescrIndex::~atmVclTransmitTrafficDescrIndex()
{
}

MibEntryPtr atmVclTransmitTrafficDescrIndex::clone()
{
	MibEntryPtr other = new atmVclTransmitTrafficDescrIndex(oid);
	((atmVclTransmitTrafficDescrIndex*)other)->replace_value(value->clone());
	((atmVclTransmitTrafficDescrIndex*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVclTransmitTrafficDescrIndex::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 2147483647))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVclTransmitTrafficDescrIndex::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVccAalType
 *
 */

atmVccAalType::atmVccAalType(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(3), VMODE_DEFAULT)
{

}

atmVccAalType::~atmVccAalType()
{
}

MibEntryPtr atmVccAalType::clone()
{
	MibEntryPtr other = new atmVccAalType(oid);
	((atmVccAalType*)other)->replace_value(value->clone());
	((atmVccAalType*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVccAalType::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2) && (v != 3)
	     && (v != 4) && (v != 5)
	     && (v != 6)) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVccAalType::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVccAal5CpcsTransmitSduSize
 *
 */

atmVccAal5CpcsTransmitSduSize::atmVccAal5CpcsTransmitSduSize(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(9188), VMODE_DEFAULT)
{

}

atmVccAal5CpcsTransmitSduSize::~atmVccAal5CpcsTransmitSduSize()
{
}

MibEntryPtr atmVccAal5CpcsTransmitSduSize::clone()
{
	MibEntryPtr other = new atmVccAal5CpcsTransmitSduSize(oid);
	((atmVccAal5CpcsTransmitSduSize*)other)->replace_value(value->clone());
	((atmVccAal5CpcsTransmitSduSize*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVccAal5CpcsTransmitSduSize::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 1) && (v <= 65535))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVccAal5CpcsTransmitSduSize::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVccAal5CpcsReceiveSduSize
 *
 */

atmVccAal5CpcsReceiveSduSize::atmVccAal5CpcsReceiveSduSize(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(9188), VMODE_DEFAULT)
{

}

atmVccAal5CpcsReceiveSduSize::~atmVccAal5CpcsReceiveSduSize()
{
}

MibEntryPtr atmVccAal5CpcsReceiveSduSize::clone()
{
	MibEntryPtr other = new atmVccAal5CpcsReceiveSduSize(oid);
	((atmVccAal5CpcsReceiveSduSize*)other)->replace_value(value->clone());
	((atmVccAal5CpcsReceiveSduSize*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVccAal5CpcsReceiveSduSize::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if (!(((v >= 1) && (v <= 65535))))
		 return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVccAal5CpcsReceiveSduSize::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVccAal5EncapsType
 *
 */

atmVccAal5EncapsType::atmVccAal5EncapsType(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(7), VMODE_DEFAULT)
{

}

atmVccAal5EncapsType::~atmVccAal5EncapsType()
{
}

MibEntryPtr atmVccAal5EncapsType::clone()
{
	MibEntryPtr other = new atmVccAal5EncapsType(oid);
	((atmVccAal5EncapsType*)other)->replace_value(value->clone());
	((atmVccAal5EncapsType*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVccAal5EncapsType::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2) && (v != 3)
	     && (v != 4) && (v != 5)
	     && (v != 6) && (v != 7)
	     && (v != 8) && (v != 9)
	     && (v != 10)) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVccAal5EncapsType::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVclCrossConnectIdentifier
 *
 */

atmVclCrossConnectIdentifier::atmVclCrossConnectIdentifier(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmVclCrossConnectIdentifier::~atmVclCrossConnectIdentifier()
{
}

MibEntryPtr atmVclCrossConnectIdentifier::clone()
{
	MibEntryPtr other = new atmVclCrossConnectIdentifier(oid);
	((atmVclCrossConnectIdentifier*)other)->replace_value(value->clone());
	((atmVclCrossConnectIdentifier*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVclRowStatus
 *
 */

atmVclRowStatus::atmVclRowStatus(const Oidx& id):
   snmpRowStatus(id, READCREATE)
{

}

atmVclRowStatus::~atmVclRowStatus()
{
}

MibEntryPtr atmVclRowStatus::clone()
{
	MibEntryPtr other = new atmVclRowStatus(oid);
	((atmVclRowStatus*)other)->replace_value(value->clone());
	((atmVclRowStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVclCastType
 *
 */

atmVclCastType::atmVclCastType(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(1), VMODE_DEFAULT)
{

}

atmVclCastType::~atmVclCastType()
{
}

MibEntryPtr atmVclCastType::clone()
{
	MibEntryPtr other = new atmVclCastType(oid);
	((atmVclCastType*)other)->replace_value(value->clone());
	((atmVclCastType*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVclCastType::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2) && (v != 3)
	    ) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVclCastType::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVclConnKind
 *
 */

atmVclConnKind::atmVclConnKind(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(1), VMODE_DEFAULT)
{

}

atmVclConnKind::~atmVclConnKind()
{
}

MibEntryPtr atmVclConnKind::clone()
{
	MibEntryPtr other = new atmVclConnKind(oid);
	((atmVclConnKind*)other)->replace_value(value->clone());
	((atmVclConnKind*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVclConnKind::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2) && (v != 3)
	     && (v != 4) && (v != 5)
	    ) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVclConnKind::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVpCrossConnectIndexNext
 *
 */

atmVpCrossConnectIndexNext* atmVpCrossConnectIndexNext::instance = 0;

atmVpCrossConnectIndexNext::atmVpCrossConnectIndexNext():
   SimMibLeaf(oidAtmVpCrossConnectIndexNext, READONLY, new SnmpInt32())
{
	// This leaf object is a singleton. In order to access it use
	// the static pointer atmVpCrossConnectIndexNext::instance.
	instance = this;

}

atmVpCrossConnectIndexNext::~atmVpCrossConnectIndexNext()
{
}



/**
 *  atmVpCrossConnectAdminStatus
 *
 */

atmVpCrossConnectAdminStatus::atmVpCrossConnectAdminStatus(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(2), VMODE_DEFAULT)
{

}

atmVpCrossConnectAdminStatus::~atmVpCrossConnectAdminStatus()
{
}

MibEntryPtr atmVpCrossConnectAdminStatus::clone()
{
	MibEntryPtr other = new atmVpCrossConnectAdminStatus(oid);
	((atmVpCrossConnectAdminStatus*)other)->replace_value(value->clone());
	((atmVpCrossConnectAdminStatus*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVpCrossConnectAdminStatus::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2)) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVpCrossConnectAdminStatus::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVpCrossConnectL2HOperStatus
 *
 */

atmVpCrossConnectL2HOperStatus::atmVpCrossConnectL2HOperStatus(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmVpCrossConnectL2HOperStatus::~atmVpCrossConnectL2HOperStatus()
{
}

MibEntryPtr atmVpCrossConnectL2HOperStatus::clone()
{
	MibEntryPtr other = new atmVpCrossConnectL2HOperStatus(oid);
	((atmVpCrossConnectL2HOperStatus*)other)->replace_value(value->clone());
	((atmVpCrossConnectL2HOperStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVpCrossConnectH2LOperStatus
 *
 */

atmVpCrossConnectH2LOperStatus::atmVpCrossConnectH2LOperStatus(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmVpCrossConnectH2LOperStatus::~atmVpCrossConnectH2LOperStatus()
{
}

MibEntryPtr atmVpCrossConnectH2LOperStatus::clone()
{
	MibEntryPtr other = new atmVpCrossConnectH2LOperStatus(oid);
	((atmVpCrossConnectH2LOperStatus*)other)->replace_value(value->clone());
	((atmVpCrossConnectH2LOperStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVpCrossConnectL2HLastChange
 *
 */

atmVpCrossConnectL2HLastChange::atmVpCrossConnectL2HLastChange(const Oidx& id):
   SimMibLeaf(id, READONLY, new TimeTicks())
{

}

atmVpCrossConnectL2HLastChange::~atmVpCrossConnectL2HLastChange()
{
}

MibEntryPtr atmVpCrossConnectL2HLastChange::clone()
{
	MibEntryPtr other = new atmVpCrossConnectL2HLastChange(oid);
	((atmVpCrossConnectL2HLastChange*)other)->replace_value(value->clone());
	((atmVpCrossConnectL2HLastChange*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVpCrossConnectH2LLastChange
 *
 */

atmVpCrossConnectH2LLastChange::atmVpCrossConnectH2LLastChange(const Oidx& id):
   SimMibLeaf(id, READONLY, new TimeTicks())
{

}

atmVpCrossConnectH2LLastChange::~atmVpCrossConnectH2LLastChange()
{
}

MibEntryPtr atmVpCrossConnectH2LLastChange::clone()
{
	MibEntryPtr other = new atmVpCrossConnectH2LLastChange(oid);
	((atmVpCrossConnectH2LLastChange*)other)->replace_value(value->clone());
	((atmVpCrossConnectH2LLastChange*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVpCrossConnectRowStatus
 *
 */

atmVpCrossConnectRowStatus::atmVpCrossConnectRowStatus(const Oidx& id):
   snmpRowStatus(id, READCREATE)
{

}

atmVpCrossConnectRowStatus::~atmVpCrossConnectRowStatus()
{
}

MibEntryPtr atmVpCrossConnectRowStatus::clone()
{
	MibEntryPtr other = new atmVpCrossConnectRowStatus(oid);
	((atmVpCrossConnectRowStatus*)other)->replace_value(value->clone());
	((atmVpCrossConnectRowStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVcCrossConnectIndexNext
 *
 */

atmVcCrossConnectIndexNext* atmVcCrossConnectIndexNext::instance = 0;

atmVcCrossConnectIndexNext::atmVcCrossConnectIndexNext():
   SimMibLeaf(oidAtmVcCrossConnectIndexNext, READONLY, new SnmpInt32())
{
	// This leaf object is a singleton. In order to access it use
	// the static pointer atmVcCrossConnectIndexNext::instance.
	instance = this;

}

atmVcCrossConnectIndexNext::~atmVcCrossConnectIndexNext()
{
}



/**
 *  atmVcCrossConnectAdminStatus
 *
 */

atmVcCrossConnectAdminStatus::atmVcCrossConnectAdminStatus(const Oidx& id):
   SimMibLeaf(id, READCREATE, new SnmpInt32(2), VMODE_DEFAULT)
{

}

atmVcCrossConnectAdminStatus::~atmVcCrossConnectAdminStatus()
{
}

MibEntryPtr atmVcCrossConnectAdminStatus::clone()
{
	MibEntryPtr other = new atmVcCrossConnectAdminStatus(oid);
	((atmVcCrossConnectAdminStatus*)other)->replace_value(value->clone());
	((atmVcCrossConnectAdminStatus*)other)->set_reference_to_table(my_table);
	return other;
}

bool atmVcCrossConnectAdminStatus::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	     && (v != 2)) return FALSE;
	// place additional code to check validity of new values here
	return TRUE;
}

int atmVcCrossConnectAdminStatus::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = SimMibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;
	// place additional code to check validity of new values here
	return SNMP_ERROR_SUCCESS;
}



/**
 *  atmVcCrossConnectL2HOperStatus
 *
 */

atmVcCrossConnectL2HOperStatus::atmVcCrossConnectL2HOperStatus(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmVcCrossConnectL2HOperStatus::~atmVcCrossConnectL2HOperStatus()
{
}

MibEntryPtr atmVcCrossConnectL2HOperStatus::clone()
{
	MibEntryPtr other = new atmVcCrossConnectL2HOperStatus(oid);
	((atmVcCrossConnectL2HOperStatus*)other)->replace_value(value->clone());
	((atmVcCrossConnectL2HOperStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVcCrossConnectH2LOperStatus
 *
 */

atmVcCrossConnectH2LOperStatus::atmVcCrossConnectH2LOperStatus(const Oidx& id):
   SimMibLeaf(id, READONLY, new SnmpInt32())
{

}

atmVcCrossConnectH2LOperStatus::~atmVcCrossConnectH2LOperStatus()
{
}

MibEntryPtr atmVcCrossConnectH2LOperStatus::clone()
{
	MibEntryPtr other = new atmVcCrossConnectH2LOperStatus(oid);
	((atmVcCrossConnectH2LOperStatus*)other)->replace_value(value->clone());
	((atmVcCrossConnectH2LOperStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVcCrossConnectL2HLastChange
 *
 */

atmVcCrossConnectL2HLastChange::atmVcCrossConnectL2HLastChange(const Oidx& id):
   SimMibLeaf(id, READONLY, new TimeTicks())
{

}

atmVcCrossConnectL2HLastChange::~atmVcCrossConnectL2HLastChange()
{
}

MibEntryPtr atmVcCrossConnectL2HLastChange::clone()
{
	MibEntryPtr other = new atmVcCrossConnectL2HLastChange(oid);
	((atmVcCrossConnectL2HLastChange*)other)->replace_value(value->clone());
	((atmVcCrossConnectL2HLastChange*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVcCrossConnectH2LLastChange
 *
 */

atmVcCrossConnectH2LLastChange::atmVcCrossConnectH2LLastChange(const Oidx& id):
   SimMibLeaf(id, READONLY, new TimeTicks())
{

}

atmVcCrossConnectH2LLastChange::~atmVcCrossConnectH2LLastChange()
{
}

MibEntryPtr atmVcCrossConnectH2LLastChange::clone()
{
	MibEntryPtr other = new atmVcCrossConnectH2LLastChange(oid);
	((atmVcCrossConnectH2LLastChange*)other)->replace_value(value->clone());
	((atmVcCrossConnectH2LLastChange*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmVcCrossConnectRowStatus
 *
 */

atmVcCrossConnectRowStatus::atmVcCrossConnectRowStatus(const Oidx& id):
   snmpRowStatus(id, READCREATE)
{

}

atmVcCrossConnectRowStatus::~atmVcCrossConnectRowStatus()
{
}

MibEntryPtr atmVcCrossConnectRowStatus::clone()
{
	MibEntryPtr other = new atmVcCrossConnectRowStatus(oid);
	((atmVcCrossConnectRowStatus*)other)->replace_value(value->clone());
	((atmVcCrossConnectRowStatus*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  aal5VccCrcErrors
 *
 */

aal5VccCrcErrors::aal5VccCrcErrors(const Oidx& id):
   SimMibLeaf(id, READONLY, new Counter32())
{

}

aal5VccCrcErrors::~aal5VccCrcErrors()
{
}

MibEntryPtr aal5VccCrcErrors::clone()
{
	MibEntryPtr other = new aal5VccCrcErrors(oid);
	((aal5VccCrcErrors*)other)->replace_value(value->clone());
	((aal5VccCrcErrors*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  aal5VccSarTimeOuts
 *
 */

aal5VccSarTimeOuts::aal5VccSarTimeOuts(const Oidx& id):
   SimMibLeaf(id, READONLY, new Counter32())
{

}

aal5VccSarTimeOuts::~aal5VccSarTimeOuts()
{
}

MibEntryPtr aal5VccSarTimeOuts::clone()
{
	MibEntryPtr other = new aal5VccSarTimeOuts(oid);
	((aal5VccSarTimeOuts*)other)->replace_value(value->clone());
	((aal5VccSarTimeOuts*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  aal5VccOverSizedSDUs
 *
 */

aal5VccOverSizedSDUs::aal5VccOverSizedSDUs(const Oidx& id):
   SimMibLeaf(id, READONLY, new Counter32())
{

}

aal5VccOverSizedSDUs::~aal5VccOverSizedSDUs()
{
}

MibEntryPtr aal5VccOverSizedSDUs::clone()
{
	MibEntryPtr other = new aal5VccOverSizedSDUs(oid);
	((aal5VccOverSizedSDUs*)other)->replace_value(value->clone());
	((aal5VccOverSizedSDUs*)other)->set_reference_to_table(my_table);
	return other;
}



/**
 *  atmTrafficDescrParamIndexNext
 *
 */

atmTrafficDescrParamIndexNext* atmTrafficDescrParamIndexNext::instance = 0;

atmTrafficDescrParamIndexNext::atmTrafficDescrParamIndexNext():
   SimMibLeaf(oidAtmTrafficDescrParamIndexNext, READONLY, new SnmpInt32())
{
	// This leaf object is a singleton. In order to access it use
	// the static pointer atmTrafficDescrParamIndexNext::instance.
	instance = this;

}

atmTrafficDescrParamIndexNext::~atmTrafficDescrParamIndexNext()
{
}



/**
 *  atmInterfaceConfEntry
 *
 */

atmInterfaceConfEntry* atmInterfaceConfEntry::instance = 0;

const index_info indAtmInterfaceConfEntry[1] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 } };

atmInterfaceConfEntry::atmInterfaceConfEntry():
   MibTable(oidAtmInterfaceConfEntry, indAtmInterfaceConfEntry, 1)
{
	// This table object is a singleton. In order to access it use
	// the static pointer atmInterfaceConfEntry::instance.
	instance = this;

	add_col(new atmInterfaceMaxVpcs(colAtmInterfaceMaxVpcs));
	add_col(new atmInterfaceMaxVccs(colAtmInterfaceMaxVccs));
	add_col(new atmInterfaceConfVpcs(colAtmInterfaceConfVpcs));
	add_col(new atmInterfaceConfVccs(colAtmInterfaceConfVccs));
	add_col(new atmInterfaceMaxActiveVpiBits(colAtmInterfaceMaxActiveVpiBits));
	add_col(new atmInterfaceMaxActiveVciBits(colAtmInterfaceMaxActiveVciBits));
	add_col(new atmInterfaceAddressType(colAtmInterfaceAddressType));
	add_col(new atmInterfaceAdminAddress(colAtmInterfaceAdminAddress));
	add_col(new atmInterfaceMyNeighborIpAddress(colAtmInterfaceMyNeighborIpAddress));
	add_col(new atmInterfaceMyNeighborIfName(colAtmInterfaceMyNeighborIfName));
	add_col(new atmInterfaceCurrentMaxVpiBits(colAtmInterfaceCurrentMaxVpiBits));
	add_col(new atmInterfaceCurrentMaxVciBits(colAtmInterfaceCurrentMaxVciBits));
	add_col(new atmInterfaceIlmiVpi(colAtmInterfaceIlmiVpi));
	add_col(new atmInterfaceIlmiVci(colAtmInterfaceIlmiVci));
	add_col(new atmInterfaceSubscrAddress(colAtmInterfaceSubscrAddress));
	/* for testing
	char buf[16];
	for (int i=0; i<5000; i++) {
		sprintf(buf, "%d", i);
		add_row(buf);
	}
	*/
}

atmInterfaceConfEntry::~atmInterfaceConfEntry()
{
}



void atmInterfaceConfEntry::set_row(MibTableRow* r, int p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8, char* p9, char* p10, char* p11, int p12, int p13, char* p14)
{
	r->get_nth(0)->replace_value(new SnmpInt32(p0));
	r->get_nth(1)->replace_value(new SnmpInt32(p1));
	r->get_nth(2)->replace_value(new SnmpInt32(p2));
	r->get_nth(3)->replace_value(new SnmpInt32(p3));
	r->get_nth(4)->replace_value(new SnmpInt32(p4));
	r->get_nth(5)->replace_value(new SnmpInt32(p5));
	r->get_nth(6)->replace_value(new SnmpInt32(p6));
	r->get_nth(7)->replace_value(new SnmpInt32(p7));
	r->get_nth(8)->replace_value(new SnmpInt32(p8));
	r->get_nth(9)->replace_value(new OctetStr(p9));
	r->get_nth(10)->replace_value(new IpAddress(p10));
	r->get_nth(11)->replace_value(new OctetStr(p11));
	r->get_nth(12)->replace_value(new SnmpInt32(p12));
	r->get_nth(13)->replace_value(new SnmpInt32(p13));
	r->get_nth(14)->replace_value(new OctetStr(p14));
}



/**
 *  atmInterfaceDs3PlcpEntry
 *
 */

atmInterfaceDs3PlcpEntry* atmInterfaceDs3PlcpEntry::instance = 0;

const index_info indAtmInterfaceDs3PlcpEntry[1] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 } };

atmInterfaceDs3PlcpEntry::atmInterfaceDs3PlcpEntry():
   MibTable(oidAtmInterfaceDs3PlcpEntry, indAtmInterfaceDs3PlcpEntry, 1)
{
	// This table object is a singleton. In order to access it use
	// the static pointer atmInterfaceDs3PlcpEntry::instance.
	instance = this;

	add_col(new atmInterfaceDs3PlcpSEFSs(colAtmInterfaceDs3PlcpSEFSs));
	add_col(new atmInterfaceDs3PlcpAlarmState(colAtmInterfaceDs3PlcpAlarmState));
	add_col(new atmInterfaceDs3PlcpUASs(colAtmInterfaceDs3PlcpUASs));
}

atmInterfaceDs3PlcpEntry::~atmInterfaceDs3PlcpEntry()
{
}



void atmInterfaceDs3PlcpEntry::set_row(MibTableRow* r, int p0, int p1, int p2)
{
	r->get_nth(0)->replace_value(new Counter32(p0));
	r->get_nth(1)->replace_value(new SnmpInt32(p1));
	r->get_nth(2)->replace_value(new Counter32(p2));
}



/**
 *  atmInterfaceTCEntry
 *
 */

atmInterfaceTCEntry* atmInterfaceTCEntry::instance = 0;

const index_info indAtmInterfaceTCEntry[1] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 } };

atmInterfaceTCEntry::atmInterfaceTCEntry():
   MibTable(oidAtmInterfaceTCEntry, indAtmInterfaceTCEntry, 1)
{
	// This table object is a singleton. In order to access it use
	// the static pointer atmInterfaceTCEntry::instance.
	instance = this;

	add_col(new atmInterfaceOCDEvents(colAtmInterfaceOCDEvents));
	add_col(new atmInterfaceTCAlarmState(colAtmInterfaceTCAlarmState));
}

atmInterfaceTCEntry::~atmInterfaceTCEntry()
{
}



void atmInterfaceTCEntry::set_row(MibTableRow* r, int p0, int p1)
{
	r->get_nth(0)->replace_value(new Counter32(p0));
	r->get_nth(1)->replace_value(new SnmpInt32(p1));
}



/**
 *  atmTrafficDescrParamEntry
 *
 */

atmTrafficDescrParamEntry* atmTrafficDescrParamEntry::instance = 0;

const index_info indAtmTrafficDescrParamEntry[1] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 } };

atmTrafficDescrParamEntry::atmTrafficDescrParamEntry():
   MibTable(oidAtmTrafficDescrParamEntry, indAtmTrafficDescrParamEntry, 1)
{
	// This table object is a singleton. In order to access it use
	// the static pointer atmTrafficDescrParamEntry::instance.
	instance = this;

	add_col(new atmTrafficDescrType(colAtmTrafficDescrType));
	add_col(new atmTrafficDescrParam1(colAtmTrafficDescrParam1));
	add_col(new atmTrafficDescrParam2(colAtmTrafficDescrParam2));
	add_col(new atmTrafficDescrParam3(colAtmTrafficDescrParam3));
	add_col(new atmTrafficDescrParam4(colAtmTrafficDescrParam4));
	add_col(new atmTrafficDescrParam5(colAtmTrafficDescrParam5));
	add_col(new atmTrafficQoSClass(colAtmTrafficQoSClass));
	add_col(new atmTrafficDescrRowStatus(colAtmTrafficDescrRowStatus));
	add_col(new atmServiceCategory(colAtmServiceCategory));
	add_col(new atmTrafficFrameDiscard(colAtmTrafficFrameDiscard));
}

atmTrafficDescrParamEntry::~atmTrafficDescrParamEntry()
{
}



void atmTrafficDescrParamEntry::set_row(MibTableRow* r, char* p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8, int p9)
{
	r->get_nth(0)->replace_value(new Oid(p0));
	r->get_nth(1)->replace_value(new SnmpInt32(p1));
	r->get_nth(2)->replace_value(new SnmpInt32(p2));
	r->get_nth(3)->replace_value(new SnmpInt32(p3));
	r->get_nth(4)->replace_value(new SnmpInt32(p4));
	r->get_nth(5)->replace_value(new SnmpInt32(p5));
	r->get_nth(6)->replace_value(new SnmpInt32(p6));
	r->get_nth(7)->replace_value(new SnmpInt32(p7));
	r->get_nth(8)->replace_value(new SnmpInt32(p8));
	r->get_nth(9)->replace_value(new SnmpInt32(p9));
}



/**
 *  atmVplEntry
 *
 */

atmVplEntry* atmVplEntry::instance = 0;

const index_info indAtmVplEntry[2] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 } };

atmVplEntry::atmVplEntry():
   MibTable(oidAtmVplEntry, indAtmVplEntry, 2)
{
	// This table object is a singleton. In order to access it use
	// the static pointer atmVplEntry::instance.
	instance = this;

	add_col(new atmVplAdminStatus(colAtmVplAdminStatus));
	add_col(new atmVplOperStatus(colAtmVplOperStatus));
	add_col(new atmVplLastChange(colAtmVplLastChange));
	add_col(new atmVplReceiveTrafficDescrIndex(colAtmVplReceiveTrafficDescrIndex));
	add_col(new atmVplTransmitTrafficDescrIndex(colAtmVplTransmitTrafficDescrIndex));
	add_col(new atmVplCrossConnectIdentifier(colAtmVplCrossConnectIdentifier));
	add_col(new atmVplRowStatus(colAtmVplRowStatus));
	add_col(new atmVplCastType(colAtmVplCastType));
	add_col(new atmVplConnKind(colAtmVplConnKind));
}

atmVplEntry::~atmVplEntry()
{
}



void atmVplEntry::set_row(MibTableRow* r, int p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8)
{
	r->get_nth(0)->replace_value(new SnmpInt32(p0));
	r->get_nth(1)->replace_value(new SnmpInt32(p1));
	r->get_nth(2)->replace_value(new TimeTicks(p2));
	r->get_nth(3)->replace_value(new SnmpInt32(p3));
	r->get_nth(4)->replace_value(new SnmpInt32(p4));
	r->get_nth(5)->replace_value(new SnmpInt32(p5));
	r->get_nth(6)->replace_value(new SnmpInt32(p6));
	r->get_nth(7)->replace_value(new SnmpInt32(p7));
	r->get_nth(8)->replace_value(new SnmpInt32(p8));
}



/**
 *  atmVclEntry
 *
 */

atmVclEntry* atmVclEntry::instance = 0;

const index_info indAtmVclEntry[3] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 } };

atmVclEntry::atmVclEntry():
   MibTable(oidAtmVclEntry, indAtmVclEntry, 3)
{
	// This table object is a singleton. In order to access it use
	// the static pointer atmVclEntry::instance.
	instance = this;

	add_col(new atmVclAdminStatus(colAtmVclAdminStatus));
	add_col(new atmVclOperStatus(colAtmVclOperStatus));
	add_col(new atmVclLastChange(colAtmVclLastChange));
	add_col(new atmVclReceiveTrafficDescrIndex(colAtmVclReceiveTrafficDescrIndex));
	add_col(new atmVclTransmitTrafficDescrIndex(colAtmVclTransmitTrafficDescrIndex));
	add_col(new atmVccAalType(colAtmVccAalType));
	add_col(new atmVccAal5CpcsTransmitSduSize(colAtmVccAal5CpcsTransmitSduSize));
	add_col(new atmVccAal5CpcsReceiveSduSize(colAtmVccAal5CpcsReceiveSduSize));
	add_col(new atmVccAal5EncapsType(colAtmVccAal5EncapsType));
	add_col(new atmVclCrossConnectIdentifier(colAtmVclCrossConnectIdentifier));
	add_col(new atmVclRowStatus(colAtmVclRowStatus));
	add_col(new atmVclCastType(colAtmVclCastType));
	add_col(new atmVclConnKind(colAtmVclConnKind));
	MibTableRow* r = add_row("1.32.64");
	set_row(r, 1, 2, 0, 0, 0, 0, 1500, 1500, 0, 1, 2, 0, 0);
}

atmVclEntry::~atmVclEntry()
{
}



void atmVclEntry::set_row(MibTableRow* r, int p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8, int p9, int p10, int p11, int p12)
{
	r->get_nth(0)->replace_value(new SnmpInt32(p0));
	r->get_nth(1)->replace_value(new SnmpInt32(p1));
	r->get_nth(2)->replace_value(new TimeTicks(p2));
	r->get_nth(3)->replace_value(new SnmpInt32(p3));
	r->get_nth(4)->replace_value(new SnmpInt32(p4));
	r->get_nth(5)->replace_value(new SnmpInt32(p5));
	r->get_nth(6)->replace_value(new SnmpInt32(p6));
	r->get_nth(7)->replace_value(new SnmpInt32(p7));
	r->get_nth(8)->replace_value(new SnmpInt32(p8));
	r->get_nth(9)->replace_value(new SnmpInt32(p9));
	r->get_nth(10)->replace_value(new SnmpInt32(p10));
	r->get_nth(11)->replace_value(new SnmpInt32(p11));
	r->get_nth(12)->replace_value(new SnmpInt32(p12));
}



/**
 *  atmVpCrossConnectEntry
 *
 */

atmVpCrossConnectEntry* atmVpCrossConnectEntry::instance = 0;

const index_info indAtmVpCrossConnectEntry[5] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 } };

atmVpCrossConnectEntry::atmVpCrossConnectEntry():
   MibTable(oidAtmVpCrossConnectEntry, indAtmVpCrossConnectEntry, 5)
{
	// This table object is a singleton. In order to access it use
	// the static pointer atmVpCrossConnectEntry::instance.
	instance = this;

	add_col(new atmVpCrossConnectAdminStatus(colAtmVpCrossConnectAdminStatus));
	add_col(new atmVpCrossConnectL2HOperStatus(colAtmVpCrossConnectL2HOperStatus));
	add_col(new atmVpCrossConnectH2LOperStatus(colAtmVpCrossConnectH2LOperStatus));
	add_col(new atmVpCrossConnectL2HLastChange(colAtmVpCrossConnectL2HLastChange));
	add_col(new atmVpCrossConnectH2LLastChange(colAtmVpCrossConnectH2LLastChange));
	add_col(new atmVpCrossConnectRowStatus(colAtmVpCrossConnectRowStatus));
}

atmVpCrossConnectEntry::~atmVpCrossConnectEntry()
{
}



void atmVpCrossConnectEntry::set_row(MibTableRow* r, int p0, int p1, int p2, int p3, int p4, int p5)
{
	r->get_nth(0)->replace_value(new SnmpInt32(p0));
	r->get_nth(1)->replace_value(new SnmpInt32(p1));
	r->get_nth(2)->replace_value(new SnmpInt32(p2));
	r->get_nth(3)->replace_value(new TimeTicks(p3));
	r->get_nth(4)->replace_value(new TimeTicks(p4));
	r->get_nth(5)->replace_value(new SnmpInt32(p5));
}



/**
 *  atmVcCrossConnectEntry
 *
 */

atmVcCrossConnectEntry* atmVcCrossConnectEntry::instance = 0;

const index_info indAtmVcCrossConnectEntry[7] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 } };

atmVcCrossConnectEntry::atmVcCrossConnectEntry():
   MibTable(oidAtmVcCrossConnectEntry, indAtmVcCrossConnectEntry, 7)
{
	// This table object is a singleton. In order to access it use
	// the static pointer atmVcCrossConnectEntry::instance.
	instance = this;

	add_col(new atmVcCrossConnectAdminStatus(colAtmVcCrossConnectAdminStatus));
	add_col(new atmVcCrossConnectL2HOperStatus(colAtmVcCrossConnectL2HOperStatus));
	add_col(new atmVcCrossConnectH2LOperStatus(colAtmVcCrossConnectH2LOperStatus));
	add_col(new atmVcCrossConnectL2HLastChange(colAtmVcCrossConnectL2HLastChange));
	add_col(new atmVcCrossConnectH2LLastChange(colAtmVcCrossConnectH2LLastChange));
	add_col(new atmVcCrossConnectRowStatus(colAtmVcCrossConnectRowStatus));
}

atmVcCrossConnectEntry::~atmVcCrossConnectEntry()
{
}



void atmVcCrossConnectEntry::set_row(MibTableRow* r, int p0, int p1, int p2, int p3, int p4, int p5)
{
	r->get_nth(0)->replace_value(new SnmpInt32(p0));
	r->get_nth(1)->replace_value(new SnmpInt32(p1));
	r->get_nth(2)->replace_value(new SnmpInt32(p2));
	r->get_nth(3)->replace_value(new TimeTicks(p3));
	r->get_nth(4)->replace_value(new TimeTicks(p4));
	r->get_nth(5)->replace_value(new SnmpInt32(p5));
}



/**
 *  aal5VccEntry
 *
 */

aal5VccEntry* aal5VccEntry::instance = 0;

const index_info indAal5VccEntry[3] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 },
	 { sNMP_SYNTAX_INT, FALSE, 1, 1 } };

aal5VccEntry::aal5VccEntry():
   MibTable(oidAal5VccEntry, indAal5VccEntry, 3)
{
	// This table object is a singleton. In order to access it use
	// the static pointer aal5VccEntry::instance.
	instance = this;

	add_col(new aal5VccCrcErrors(colAal5VccCrcErrors));
	add_col(new aal5VccSarTimeOuts(colAal5VccSarTimeOuts));
	add_col(new aal5VccOverSizedSDUs(colAal5VccOverSizedSDUs));
}

aal5VccEntry::~aal5VccEntry()
{
}



void aal5VccEntry::set_row(MibTableRow* r, int p0, int p1, int p2)
{
	r->get_nth(0)->replace_value(new Counter32(p0));
	r->get_nth(1)->replace_value(new Counter32(p1));
	r->get_nth(2)->replace_value(new Counter32(p2));
}



atm_mib::atm_mib(): MibGroup("1.3.6.1.2.1.37", "atmMIB")
{
	add(new atmInterfaceConfEntry());
	add(new atmInterfaceDs3PlcpEntry());
	add(new atmInterfaceTCEntry());
	add(new atmTrafficDescrParamEntry());
	add(new atmVplEntry());
	add(new atmVclEntry());
	add(new atmVpCrossConnectIndexNext());
	add(new atmVpCrossConnectEntry());
	add(new atmVcCrossConnectIndexNext());
	add(new atmVcCrossConnectEntry());
	add(new aal5VccEntry());
	add(new atmTrafficDescrParamIndexNext());
}

#ifdef AGENTPP_NAMESPACE
}
#endif

