/*_############################################################################
  _## 
  _##  agentpp_notifytest_mib.cpp  
  _## 
  _##
  _##  AGENT++ API Version 3.5.31
  _##  -----------------------------------------------
  _##  Copyright (C) 2000-2010 Frank Fock, Jochen Katz
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##  WHEREAS,  Frank  Fock  and  Jochen  Katz  are  the  owners of valuable
  _##  intellectual  property rights relating to  the AGENT++ API and wish to
  _##  license AGENT++ subject to the  terms and conditions set forth  below;
  _##  and
  _##
  _##  WHEREAS, you ("Licensee") acknowledge  that Frank Fock and Jochen Katz
  _##  have the right  to grant licenses  to the intellectual property rights
  _##  relating to  AGENT++, and that you desire  to obtain a license  to use
  _##  AGENT++ subject to the terms and conditions set forth below;
  _##
  _##  Frank  Fock    and Jochen   Katz   grants  Licensee  a  non-exclusive,
  _##  non-transferable, royalty-free  license  to use   AGENT++ and  related
  _##  materials without  charge provided the Licensee  adheres to all of the
  _##  terms and conditions of this Agreement.
  _##
  _##  By downloading, using, or  copying  AGENT++  or any  portion  thereof,
  _##  Licensee  agrees to abide  by  the intellectual property  laws and all
  _##  other   applicable laws  of  Germany,  and  to all of   the  terms and
  _##  conditions  of this Agreement, and agrees  to take all necessary steps
  _##  to  ensure that the  terms and  conditions of  this Agreement are  not
  _##  violated  by any person  or entity under the  Licensee's control or in
  _##  the Licensee's service.
  _##
  _##  Licensee shall maintain  the  copyright and trademark  notices  on the
  _##  materials  within or otherwise  related   to AGENT++, and  not  alter,
  _##  erase, deface or overprint any such notice.
  _##
  _##  Except  as specifically   provided in  this  Agreement,   Licensee  is
  _##  expressly   prohibited  from  copying,   merging,  selling,   leasing,
  _##  assigning,  or  transferring  in  any manner,  AGENT++ or  any portion
  _##  thereof.
  _##
  _##  Licensee may copy materials   within or otherwise related   to AGENT++
  _##  that bear the author's copyright only  as required for backup purposes
  _##  or for use solely by the Licensee.
  _##
  _##  Licensee may  not distribute  in any  form  of electronic  or  printed
  _##  communication the  materials  within or  otherwise  related to AGENT++
  _##  that  bear the author's  copyright, including  but  not limited to the
  _##  source   code, documentation,  help  files, examples,  and benchmarks,
  _##  without prior written consent from the authors.  Send any requests for
  _##  limited distribution rights to fock@agentpp.com.
  _##
  _##  Licensee  hereby  grants  a  royalty-free  license  to  any  and   all 
  _##  derivatives  based  upon this software  code base,  that  may  be used
  _##  as a SNMP  agent development  environment or a  SNMP agent development 
  _##  tool.
  _##
  _##  Licensee may  modify  the sources  of AGENT++ for  the Licensee's  own
  _##  purposes.  Thus, Licensee  may  not  distribute  modified  sources  of
  _##  AGENT++ without prior written consent from the authors. 
  _##
  _##  The Licensee may distribute  binaries derived from or contained within
  _##  AGENT++ provided that:
  _##
  _##  1) The Binaries are  not integrated,  bundled,  combined, or otherwise
  _##     associated with a SNMP agent development environment or  SNMP agent
  _##     development tool; and
  _##
  _##  2) The Binaries are not a documented part of any distribution material. 
  _##
  _##
  _##  THIS  SOFTWARE  IS  PROVIDED ``AS  IS''  AND  ANY  EXPRESS OR  IMPLIED
  _##  WARRANTIES, INCLUDING, BUT NOT LIMITED  TO, THE IMPLIED WARRANTIES  OF
  _##  MERCHANTABILITY AND FITNESS FOR  A PARTICULAR PURPOSE  ARE DISCLAIMED.
  _##  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
  _##  INDIRECT,   INCIDENTAL,  SPECIAL, EXEMPLARY,  OR CONSEQUENTIAL DAMAGES
  _##  (INCLUDING,  BUT NOT LIMITED  TO,  PROCUREMENT OF SUBSTITUTE  GOODS OR
  _##  SERVICES; LOSS OF  USE,  DATA, OR PROFITS; OR  BUSINESS  INTERRUPTION)
  _##  HOWEVER CAUSED  AND ON ANY THEORY  OF  LIABILITY, WHETHER IN CONTRACT,
  _##  STRICT LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
  _##  IN  ANY WAY OUT OF  THE USE OF THIS  SOFTWARE,  EVEN IF ADVISED OF THE
  _##  POSSIBILITY OF SUCH DAMAGE. 
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:07:56 CEST 2010 
  _##  
  _##########################################################################*/



//--AgentGen BEGIN=_BEGIN
//--AgentGen END


#include "agentpp_notifytest_mib.h"



/**
 *  generated by AgentGen 1.6.1 for AGENT++v3.4 
 * Fri Jul 06 11:45:57 GMT+02:00 2001.
 */

#ifdef SNMP_PP_NAMESPACE
using namespace Snmp_pp;
#endif

//--AgentGen BEGIN=_INCLUDE
#include <stdlib.h>
#ifdef AGENTPP_NAMESPACE
namespace Agentpp {
#endif
//--AgentGen END


/**
 *  agentppNotifyTest
 *
 */

agentppNotifyTest* agentppNotifyTest::instance = 0;

agentppNotifyTest::agentppNotifyTest():
   MibLeaf(oidAgentppNotifyTest, READWRITE, new SnmpInt32())
{
	// This leaf object is a singleton. In order to access it use
	// the static pointer agentppNotifyTest::instance.
	instance = this;

	//--AgentGen BEGIN=agentppNotifyTest::agentppNotifyTest
	//--AgentGen END

}

agentppNotifyTest::~agentppNotifyTest()
{

	//--AgentGen BEGIN=agentppNotifyTest::~agentppNotifyTest
	//--AgentGen END
}

long agentppNotifyTest::get_state()
{
	return (long)*((SnmpInt32*)value);
}

void agentppNotifyTest::set_state(long l)
{

	//--AgentGen BEGIN=agentppNotifyTest::set_state
	//--AgentGen END
	*((SnmpInt32*)value) = l;
}

int agentppNotifyTest::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppNotifyTest::set
	long v;
	vb.get_value(v);
	switch (v) {
	case e_agentppNotifyTestAllTypes:
	  send_agentppNotifyTestAllTypes();
	  break;
	}
	//--AgentGen END
	return MibLeaf::set(vb);
}

bool agentppNotifyTest::value_ok(const Vbx& vb)
{
	long v;
	vb.get_value(v);
	if ((v != 1)
	    ) return FALSE;

	//--AgentGen BEGIN=agentppNotifyTest::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppNotifyTest::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppNotifyTest::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppNotifyTest
void agentppNotifyTest::send_agentppNotifyTestAllTypes() {
	Vbx* vbs = new Vbx[9];
	int n = 0;
	vbs[n  ].set_oid("1.3.6.1.2.1.92.1.3.2.1.4.0.1");
	vbs[n++].set_value(Counter32(rand()));
	vbs[n  ].set_oid("1.3.6.1.2.1.92.1.3.2.1.5.0.1");
	vbs[n++].set_value(Gauge32(rand()));
	vbs[n  ].set_oid("1.3.6.1.2.1.92.1.3.2.1.6.0.1");
	vbs[n++].set_value(TimeTicks(rand()));
	vbs[n  ].set_oid("1.3.6.1.2.1.92.1.3.2.1.7.0.1");
	vbs[n++].set_value(SnmpInt32(rand()));
	vbs[n  ].set_oid("1.3.6.1.2.1.92.1.3.2.1.8.0.1");
	OctetStr s;
	int length = rand()/(RAND_MAX/5);
	for (int i=0; i<length; i++) {
	  s += (unsigned char)(rand()/(RAND_MAX/128)+64);
	}
	vbs[n++].set_value(s);
	vbs[n  ].set_oid("1.3.6.1.2.1.92.1.3.2.1.9.0.1");
	char ipaddr[30];
	sprintf(ipaddr, "%d.%d.%d.%d", 
		rand()/(RAND_MAX/256), 
		rand()/(RAND_MAX/256),
		rand()/(RAND_MAX/256),
		rand()/(RAND_MAX/256));
	vbs[n++].set_value(IpAddress(ipaddr));
	vbs[n  ].set_oid("1.3.6.1.2.1.92.1.3.2.1.10.0.1");
	vbs[n++].set_value(Oid("1.3.6.1.2.1.340775556.0"));
	vbs[n  ].set_oid("1.3.6.1.2.1.92.1.3.2.1.11.0.1");
	unsigned long low = rand();
	unsigned long high = rand();
	vbs[n++].set_value(Counter64(high, low));
	vbs[n  ].set_oid("1.3.6.1.2.1.92.1.3.2.1.12.0.1");
	OpaqueStr op(s);
	vbs[n++].set_value(op);
	agentppNotifyTestAllTypes no;
	no.generate(vbs, 9, "");
	for (int j=0; j<9; j++) {
		LOG_BEGIN(DEBUG_LOG | 1);
		LOG("Test notification vb sent (#)(oid)(val)(syntax)");
		LOG(j);
		LOG(vbs[j].get_printable_oid());
		LOG(vbs[j].get_printable_value());
		LOG(vbs[j].get_syntax());
		LOG_END;
	}
	delete[] vbs;
}
//--AgentGen END




/**
 *  agentppNotifyTestAllTypes
 *
 */

agentppNotifyTestAllTypes::agentppNotifyTestAllTypes(): NotificationOriginator()
{

	//--AgentGen BEGIN=agentppNotifyTestAllTypes::agentppNotifyTestAllTypes
	//--AgentGen END
}

agentppNotifyTestAllTypes::~agentppNotifyTestAllTypes()
{

	//--AgentGen BEGIN=agentppNotifyTestAllTypes::~agentppNotifyTestAllTypes
	//--AgentGen END
}

void agentppNotifyTestAllTypes::generate(Vbx* vbs, int sz, const OctetStr& context)
{

	//--AgentGen BEGIN=agentppNotifyTestAllTypes::generate
	//--AgentGen END
	if (sz < 9) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: too few var binds (given) (expected)");
		LOG(sz);
		LOG(9);
		LOG_END;
		return;
	}
	if (!(vbs[0].get_oid().in_subtree_of("1.3.6.1.2.1.92.1.3.2.1.4"))) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: wrong var bind (no.) (given) (expected)");
		LOG(1l);
		LOG(vbs[0].get_printable_oid());
		LOG("1.3.6.1.2.1.92.1.3.2.1.4");
		LOG_END;
		return;
	}
	if (!(vbs[1].get_oid().in_subtree_of("1.3.6.1.2.1.92.1.3.2.1.5"))) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: wrong var bind (no.) (given) (expected)");
		LOG(2l);
		LOG(vbs[1].get_printable_oid());
		LOG("1.3.6.1.2.1.92.1.3.2.1.5");
		LOG_END;
		return;
	}
	if (!(vbs[2].get_oid().in_subtree_of("1.3.6.1.2.1.92.1.3.2.1.6"))) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: wrong var bind (no.) (given) (expected)");
		LOG(3l);
		LOG(vbs[2].get_printable_oid());
		LOG("1.3.6.1.2.1.92.1.3.2.1.6");
		LOG_END;
		return;
	}
	if (!(vbs[3].get_oid().in_subtree_of("1.3.6.1.2.1.92.1.3.2.1.7"))) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: wrong var bind (no.) (given) (expected)");
		LOG(4l);
		LOG(vbs[3].get_printable_oid());
		LOG("1.3.6.1.2.1.92.1.3.2.1.7");
		LOG_END;
		return;
	}
	if (!(vbs[4].get_oid().in_subtree_of("1.3.6.1.2.1.92.1.3.2.1.8"))) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: wrong var bind (no.) (given) (expected)");
		LOG(5l);
		LOG(vbs[4].get_printable_oid());
		LOG("1.3.6.1.2.1.92.1.3.2.1.8");
		LOG_END;
		return;
	}
	if (!(vbs[5].get_oid().in_subtree_of("1.3.6.1.2.1.92.1.3.2.1.9"))) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: wrong var bind (no.) (given) (expected)");
		LOG(6l);
		LOG(vbs[5].get_printable_oid());
		LOG("1.3.6.1.2.1.92.1.3.2.1.9");
		LOG_END;
		return;
	}
	if (!(vbs[6].get_oid().in_subtree_of("1.3.6.1.2.1.92.1.3.2.1.10"))) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: wrong var bind (no.) (given) (expected)");
		LOG(7l);
		LOG(vbs[6].get_printable_oid());
		LOG("1.3.6.1.2.1.92.1.3.2.1.10");
		LOG_END;
		return;
	}
	if (!(vbs[7].get_oid().in_subtree_of("1.3.6.1.2.1.92.1.3.2.1.11"))) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: wrong var bind (no.) (given) (expected)");
		LOG(8l);
		LOG(vbs[7].get_printable_oid());
		LOG("1.3.6.1.2.1.92.1.3.2.1.11");
		LOG_END;
		return;
	}
	if (!(vbs[8].get_oid().in_subtree_of("1.3.6.1.2.1.92.1.3.2.1.12"))) {
		LOG_BEGIN(ERROR_LOG | 1);
		LOG("agentppNotifyTestAllTypes: wrong var bind (no.) (given) (expected)");
		LOG(9l);
		LOG(vbs[8].get_printable_oid());
		LOG("1.3.6.1.2.1.92.1.3.2.1.12");
		LOG_END;
		return;
	}
	Mib::instance->
	    notify(context, oidAgentppNotifyTestAllTypes, vbs, sz);
}


//--AgentGen BEGIN=agentppNotifyTestAllTypes
//--AgentGen END


agentpp_notifytest_mib::agentpp_notifytest_mib():
   MibGroup("1.3.6.1.4.1.4976.6.2", "agentppNotifyTestMIB")
{

	//--AgentGen BEGIN=agentpp_notifytest_mib::agentpp_notifytest_mib
	//--AgentGen END
	add(new agentppNotifyTest());

	//--AgentGen BEGIN=agentpp_notifytest_mib::agentpp_notifytest_mib:post
	//--AgentGen END
}


//--AgentGen BEGIN=agentpp_notifytest_mib
//--AgentGen END



//--AgentGen BEGIN=_END
#ifdef AGENTPP_NAMESPACE
}
#endif

//--AgentGen END
