#!/usr/bin/perl

# lib.pl is the file where database specific things should live,
# whereever possible. For example, you define certain constants
# here and the like.

use strict;
use v5.10;

use Cwd;
use File::Basename;
use File::Path;
use File::Slurp;
use File::Spec;
use File::Temp;
use JSON;

my $test_dir;
END { defined( $test_dir ) and rmtree $test_dir }

sub test_dir
{
    unless( defined( $test_dir ) )
    {
	$test_dir = File::Spec->rel2abs( File::Spec->curdir () );
	$test_dir = File::Spec->catdir ( $test_dir, "test_output_" . $$ );
	$test_dir = VMS::Filespec::unixify($test_dir) if $^O eq 'VMS';
	rmtree $test_dir;
	mkpath $test_dir;
    }

    return $test_dir;
}

sub json_config_file
{
    my $config = shift;
    my $fn_base = shift;
    $fn_base //="apdex.json";
    my $json = JSON->new();
    my $enc = $json->encode($config);
    my $cli_config_filename = File::Spec->catfile( test_dir, $fn_base );
    write_file( $cli_config_filename, $enc ) ;
    return $cli_config_filename;
}

1;
