#!perl -w

use strictures;
use Cwd;
use File::Spec;
use File::Basename;

use Test::More;
use App::Cmd::Tester;
use Data::Dumper;

my $dist_basedir =
  Cwd::abs_path( File::Spec->catdir( File::Basename::dirname($0), File::Spec->updir() ) );

use_ok("CLI::App::Perf::Index");

my $lib_pl = File::Spec->catfile( $dist_basedir, "t", "lib.pl" );
do $lib_pl;

my $test_config = {
                    "connect_info" => {
                                        "dsn"      => "dbi:SQLite:dbname=:memory:",
                                        "user"     => "",
                                        "password" => ""
                                      },
                      "log_adapter" => {
                                   name => "Dispatch",
                                   args => [ outputs => [ [ 'Screen', min_level => 'notice' ], ], ],
                      },
                  };

my $cli_config_filename = json_config_file($test_config);
my ( $service_config_file, $data_file, $result );

$data_file           = File::Spec->catfile( $dist_basedir, qw(test_data exam1.data) );
$service_config_file = File::Spec->catfile( $dist_basedir, qw(test_data exam1-rules.json) );

$result = test_app(
                    'CLI::App::Perf::Index' => [
                                                 qw(approve --configfile), $cli_config_filename,
                                                 "--service-details",      $service_config_file,
                                                 "--input-file",           $data_file
                                               ]
                  );
isnt( $result->output, '', 'Got report about imported data during approving ExampleAppOne' );
if ( $result->output =~ m/Fetched (\d+) rows for ExampleAppOne/ )
{
    is( $1, 20, 'Right numbers of records parsed for ExampleAppOne' );
}
else
{
    like( $result->output,
          qr/Fetched (\d+) rows for ExampleAppOne/,
          'Amount of records parsed for ExampleAppOne' );
}
if ( $result->output =~ m/(\d+) rows: (\d+) converted -- (\d+) skipped -- (\d+) failed/ )
{
    is( $1, 20, 'Right numbers of records processed for ExampleAppOne' );
    is( $2, 18, 'Right numbers of records converted for ExampleAppOne' );
    is( $3, 2,  'Right numbers of records skipped for ExampleAppOne' );
    is( $4, 0,  'Right numbers of records failed for ExampleAppOne' );
}
else
{
    like( $result->output,
          qr/(\d+) rows: (\d+) converted -- (\d+) skipped -- (\d+) failed/,
          'Amount of records processed for ExampleAppOne' );
}

is( $result->error,     undef, 'nothing sent to error approving for App One' );
is( $result->exit_code, 0,     'everything went fine approving for App One' );

done_testing();
