package CLI::App::Perf::Index::Role::ServiceDB;

use strictures;
use Moose::Role;

# ABSTRACT: glue between DBIx::Class (Schema->connect) and MooseX::Getopt

with 'MooseX::Getopt';

require App::Perf::Index::Schema;

has connect_info => (
                      traits        => [qw(Getopt)],
                      isa           => 'HashRef',
                      is            => 'rw',
                      cmd_flag      => 'connect-info',
                      documentation => 'How to connect to database',
                      required      => 1,
                    );

has schema => (
                traits   => [qw(NoGetopt)],
                is       => 'ro',
                builder  => '_schema_connect',
                init_arg => undef,
                lazy     => 1
              );

sub _schema_connect
{
    my $self = $_[0];

    App::Perf::Index::Schema->connect( $self->connect_info );
}

1;
