package CLI::App::Perf::Index::Role::Log;

use strictures;
use Moose::Role;

# ABSTRACT: provides log facility

use MooseX::Getopt ();    # no-op, except it loads the NoGetopt trait
use MooseX::Types::LogAny qw(LogAny);

use Class::Load qw(load_class);

has logger => (
                traits  => [qw(NoGetopt)],
                isa     => LogAny,
                is      => 'ro',
                lazy    => 1,
                builder => '_create_logger',
              );

has log_adapter => (
                     traits        => [qw(Getopt)],
                     isa           => 'HashRef',
                     is            => 'rw',
                     cmd_flag      => 'log-adapter',
                     documentation => 'choose the logging adapter (from Log::Any)',
                     required      => 0,
                   );

sub _create_logger
{
    my $log_adapter = $_[0]->log_adapter();

    if( defined($log_adapter->{name}) )
    {
	my @log_adapter_opts;

	$log_adapter->{options} and push @log_adapter_opts, $log_adapter->{options};
	push @log_adapter_opts, $log_adapter->{name};
	$log_adapter->{args} and push @log_adapter_opts, @{$log_adapter->{args}};

	load_class("Log::Any::Adapter")->set( @log_adapter_opts );
    }

    return load_class('Log::Any')->get_logger;
}

1;
