package CLI::App::Perf::Index::Role::FindConfigFile;

use strictures;
use Moose::Role;

# ABSTRACT: provides reasonable default for config file locations

use MooseX::Getopt ();    # no-op, except it loads the NoGetopt trait
use MooseX::Types::Moose 'Undef';
use MooseX::Types::Path::Class qw(Dir File);

# with "MooseX::ConfigFromFile";
with "MooseX::SimpleConfig";

require File::ConfigDir;
require File::Find::Rule;

# has 'configfile' => (
#     is => 'ro', isa => File|Undef,
#     coerce => 1,
#     traits => ['Getopt'],
#     documentation => 'the filename containing default configuration data for the platform',
#     predicate => '_has_configfile',
#     # lazy => 1,
#     default => sub { my $class = shift; $class->_find_config_file; },
# );

my $app_arg0;

override prepare => sub {
    my ( $class, $app ) = @_;
    $app_arg0 = $app->arg0;

    return super();
};

sub _get_default_configfile { $_[0]->_find_config_file; }

sub _find_config_file
{
    my $class = $_[0];

    # my @cfg_dirs    = defined($ENV{MX_FIND_CONFIG_FILE_DIR}) ? ($ENV{MX_FIND_CONFIG_FILE_DIR}) : File::ConfigDir::config_dirs();
    my @cfg_dirs  = File::ConfigDir::config_dirs();
    my @cfg_bases = $class->_config_file_basename;
    @cfg_bases or return;
    my @cfg_exts = Config::Any->extensions();
    @cfg_exts or return;

    # XXX Quantum::Superpositions => all(@cfg_bases) . "." . all(@cfg_exts)
    #     or when Syntax::Keyword::Junction supports . or + operator ...
    my @cfg_pattern = map {
        my $ext = $_;
        map { $_ . "." . $ext } @cfg_bases
    } @cfg_exts;
    my @cfg_files = File::Find::Rule->file()->name(@cfg_pattern)->maxdepth(1)->in(@cfg_dirs);

    @cfg_files or return;
    \@cfg_files;
}

sub _config_file_basename
{
    my $class = $_[0];
    return ($app_arg0);
}

1;
