package CLI::App::Perf::Index::Role::Deploy;

use strictures;
use Moose::Role;

# ABSTRACT: deploys new DB

with "CLI::App::Perf::Index::Role::ServiceDB",
     "CLI::App::Perf::Index::Role::Log";

sub deploy
{
    my $self = shift;

    my $logger = $self->logger;
    my $schema = $self->schema;

    $logger->trace("going to deploy schema") if $logger->is_trace();
    $schema->deploy();
    $logger->trace("going to initialize schema") if $logger->is_trace();
    $schema->init();
    $logger->info("database initialized") if $logger->is_info();

    return 0;
}

1;
