package CLI::App::Perf::Index::Role::AutoHelp;

use strictures;
use Moose::Role;

# ABSTRACT: automatically adds reaction to --help (for MooseX::Getopt apps)

requires qw(help_flag execute);

around execute => sub {
    my ( $orig, $self, $opt, $args ) = @_;
    if ( $self->help_flag )
    {
        eval $@;
        my $desc = $self->description;
        length($desc) and $desc .= "\n";

        my $ut = join "\n",
          eval { $self->usage->leader_text },
          $desc,
          eval { $self->usage->option_text };

        print "$ut\n";

        return 0;
    }
    else
    {
        return $self->$orig( $opt, $args );
    }
};

1;
