package CLI::App::Perf::Index::Command::approve;

use v5.14;
use strictures;
use Moose;

# extends qw(CLI::App::Perf::Index::Command);
extends qw(MooseX::App::Cmd::Command);
with 'CLI::App::Perf::Index::Role::AutoHelp', 'CLI::App::Perf::Index::Role::Import',
  'CLI::App::Perf::Index::Role::Register', 'CLI::App::Perf::Index::Role::Deploy',
  #  'MooseX::SimpleConfig',
  'CLI::App::Perf::Index::Role::FindConfigFile';

# ABSTRACT: command to approve given service configuration using specified data samples

use File::Spec ();

has 'connect_info' => (
                        traits   => [qw(NoGetopt)],
                        isa      => 'HashRef',
                        is       => 'rw',
                        builder  => '_connect_info',
                        init_arg => undef,
                        lazy     => 1
                      );

has '+service' => (
                    traits   => [qw(NoGetopt)],
                    is       => 'ro',
                    required => 0,
                    init_arg => undef,
                    builder  => '_service_name',
                    lazy     => 1
                  );

sub _connect_info
{
    my $self = shift;

    my $connect_config = {
                           "dsn"      => "dbi:SQLite:dbname=:memory:",
                           "user"     => "",
                           "password" => ""
                         };
    return $connect_config;
}

sub _service_name { $_[0]->service_info->{SERVICE}->{NAME} }

sub description
{
    "This command will approve given service configuration using specified data samples.";
}

sub execute
{
    my ( $self, $opt, $args ) = @_;
    my $rc;

    $rc = $self->deploy();
    $rc and return $rc;
    $rc = $self->register();
    $rc and return $rc;
    $rc = $self->import_data();

    return $rc;
}

1;
