use utf8;

package App::Perf::Index::Schema::Result::TransformRule;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY THE FIRST PART OF THIS FILE

=head1 NAME

App::Perf::Index::Schema::Result::TransformRule

=cut

use strict;
use warnings;

use parent 'DBIx::Class::Core';

__PACKAGE__->load_components(qw{Helper::Row::ToJSON});

=head1 TABLE: C<TRANSFORM_RULES>

=cut

__PACKAGE__->table("TRANSFORM_RULES");

=head1 ACCESSORS

=head2 transform_id

  data_type: 'integer'
  is_auto_increment: 1
  is_nullable: 0

=head2 skip

  data_type: 'text'
  is_nullable: 1

=head2 assert

  data_type: 'text'
  is_nullable: 1

=head2 bucket

  data_type: 'text'
  is_nullable: 0

=head2 revbuck

  data_type: 'text'
  is_nullable: 0

=head2 time_slice

  data_type: 'text'
  is_nullable: 0

=head2 region

  data_type: 'text'
  is_nullable: 0

=head2 category

  data_type: 'text'
  is_nullable: 0

=head2 used_mods

  data_type: 'text'
  is_nullable: 1

=head2 required_mods

  data_type: 'text'
  is_nullable: 1

=cut

__PACKAGE__->add_columns(
                          "transform_id",
                          {
                             data_type         => "integer",
                             is_auto_increment => 1,
                             is_nullable       => 0
                          },
                          "skip",
                          {
                             data_type   => "text",
                             is_nullable => 1
                          },
                          "assert",
                          {
                             data_type   => "text",
                             is_nullable => 1
                          },
                          "revbuck",
                          {
                             data_type   => "text",
                             is_nullable => 0
                          },
                          "bucket",
                          {
                             data_type   => "text",
                             is_nullable => 0
                          },
                          "time_slice",
                          {
                             data_type   => "text",
                             is_nullable => 0
                          },
                          "region",
                          {
                             data_type   => "text",
                             is_nullable => 0
                          },
                          "category",
                          {
                             data_type   => "text",
                             is_nullable => 0
                          },
                          "used_mods",
                          {
                             data_type   => "text",
                             is_nullable => 1
                          },
                          "required_mods",
                          {
                             data_type   => "text",
                             is_nullable => 1
                          },
                        );

=head1 PRIMARY KEY

=over 4

=item * L</transform_id>

=back

=cut

__PACKAGE__->set_primary_key("transform_id");

=head1 RELATIONS

=head2 services

Type: has_many

Related object: L<App::Perf::Index::Schema::Result::Service>

=cut

__PACKAGE__->has_many(
                       "services",
                       "App::Perf::Index::Schema::Result::Service",
                       { "foreign.transform_id" => "self.transform_id" },
                       {
                          cascade_copy   => 0,
                          cascade_delete => 0
                       },
                     );

# Created by DBIx::Class::Schema::Loader v0.07033 @ 2012-09-17 10:14:02
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:cWN/XMiKZ5GjUaKdqj1lyQ

# ABSTRACT: table definition for DBIC schema for table TRANSFORM_RULES.

# You can replace this text with custom code or comments, and it will be preserved on regeneration
1;
