use utf8;

package App::Perf::Index::Schema::Result::Service;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY THE FIRST PART OF THIS FILE

=head1 NAME

App::Perf::Index::Schema::Result::Service

=cut

use strict;
use warnings;

use parent 'DBIx::Class::Core';

__PACKAGE__->load_components(qw{Helper::Row::ToJSON});

=head1 TABLE: C<SERVICES>

=cut

__PACKAGE__->table("SERVICES");

=head1 ACCESSORS

=head2 service_id

  data_type: 'integer'
  is_auto_increment: 1
  is_nullable: 0

=head2 service_name

  data_type: 'varchar'
  is_nullable: 0
  size: 64

=head2 fetch_id

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 1

=head2 transform_id

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 1

=cut

__PACKAGE__->add_columns(
                          "service_id",
                          {
                             data_type         => "integer",
                             is_auto_increment => 1,
                             is_nullable       => 0
                          },
                          "service_name",
                          {
                             data_type   => "varchar",
                             is_nullable => 0,
                             size        => 64
                          },
                          "fetch_id",
                          {
                             data_type      => "integer",
                             is_foreign_key => 1,
                             is_nullable    => 1
                          },
                          "transform_id",
                          {
                             data_type      => "integer",
                             is_foreign_key => 1,
                             is_nullable    => 1
                          },
                        );

=head1 PRIMARY KEY

=over 4

=item * L</service_id>

=back

=cut

__PACKAGE__->set_primary_key("service_id");

=head1 UNIQUE CONSTRAINTS

=head2 C<service_name_unique>

=over 4

=item * L</service_name>

=back

=cut

__PACKAGE__->add_unique_constraint( "service_name_unique", ["service_name"] );

=head1 RELATIONS

=head2 fetch

Type: belongs_to

Related object: L<App::Perf::Index::Schema::Result::FetchRule>

=cut

__PACKAGE__->belongs_to(
                         "fetch",
                         "App::Perf::Index::Schema::Result::FetchRule",
                         { fetch_id => "fetch_id" },
                         {
                            is_deferrable => 0,
                            join_type     => "LEFT",
                            on_delete     => "NO ACTION",
                            on_update     => "NO ACTION",
                         },
                       );

=head2 categories

Type: has_many

Related object: L<App::Perf::Index::Schema::Result::PerformanceData>

=cut

__PACKAGE__->has_many(
                       "categories",
                       "App::Perf::Index::Schema::Result::Category",
                       { "foreign.service_id" => "self.service_id" },
                       {
                          cascade_copy   => 0,
                          cascade_delete => 0
                       },
                     );

=head2 transform

Type: belongs_to

Related object: L<App::Perf::Index::Schema::Result::TransformRule>

=cut

__PACKAGE__->belongs_to(
                         "transform",
                         "App::Perf::Index::Schema::Result::TransformRule",
                         { transform_id => "transform_id" },
                         {
                            is_deferrable => 0,
                            join_type     => "LEFT",
                            on_delete     => "NO ACTION",
                            on_update     => "NO ACTION",
                         },
                       );

# Created by DBIx::Class::Schema::Loader v0.07033 @ 2012-09-17 10:14:02
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:BcfAyCyPf2QxYJ7klwcC6A

# ABSTRACT: table definition for DBIC schema for table SERVICES.

# You can replace this text with custom code or comments, and it will be preserved on regeneration
1;
