use utf8;

package App::Perf::Index::Schema::Result::Region;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY THE FIRST PART OF THIS FILE

=head1 NAME

App::Perf::Index::Schema::Result::Region

=cut

use strict;
use warnings;

use parent 'DBIx::Class::Core';

__PACKAGE__->load_components(qw{Helper::Row::ToJSON});

=head1 TABLE: C<REGIONS>

=cut

__PACKAGE__->table("REGIONS");

=head1 ACCESSORS

=head2 region_id

  data_type: 'integer'
  is_auto_increment: 1
  is_nullable: 0

=head2 region_name

  data_type: 'varchar'
  is_nullable: 1
  size: 64

=head2 alpha2_code

  data_type: 'varchar'
  is_nullable: 0
  size: 2

=head2 alpha3_code

  data_type: 'varchar'
  is_nullable: 0
  size: 3

=head2 numeric_code

  data_type: 'integer'
  is_nullable: 0

=cut

__PACKAGE__->add_columns(
                          "region_id",
                          {
                             data_type         => "integer",
                             is_auto_increment => 1,
                             is_nullable       => 0
                          },
                          "region_name",
                          {
                             data_type   => "varchar",
                             is_nullable => 1,
                             size        => 64
                          },
                          "alpha2_code",
                          {
                             data_type   => "varchar",
                             is_nullable => 0,
                             size        => 2
                          },
                          "alpha3_code",
                          {
                             data_type   => "varchar",
                             is_nullable => 0,
                             size        => 3
                          },
                          "numeric_code",
                          {
                             data_type   => "integer",
                             is_nullable => 0
                          },
                        );

=head1 PRIMARY KEY

=over 4

=item * L</region_id>

=back

=cut

__PACKAGE__->set_primary_key("region_id");

=head1 UNIQUE CONSTRAINTS

=head2 C<alpha2_code_unique>

=over 4

=item * L</alpha2_code>

=back

=cut

__PACKAGE__->add_unique_constraint( "alpha2_code_unique", ["alpha2_code"] );

=head2 C<alpha3_code_unique>

=over 4

=item * L</alpha3_code>

=back

=cut

__PACKAGE__->add_unique_constraint( "alpha3_code_unique", ["alpha3_code"] );

=head2 C<numeric_code_unique>

=over 4

=item * L</numeric_code>

=back

=cut

__PACKAGE__->add_unique_constraint( "numeric_code_unique", ["numeric_code"] );

=head2 C<region_name_unique>

=over 4

=item * L</region_name>

=back

=cut

__PACKAGE__->add_unique_constraint( "region_name_unique", ["region_name"] );

=head1 RELATIONS

=head2 performance_datas

Type: has_many

Related object: L<App::Perf::Index::Schema::Result::PerformanceData>

=cut

__PACKAGE__->has_many(
                       "performance_datas",
                       "App::Perf::Index::Schema::Result::PerformanceData",
                       { "foreign.region_id" => "self.region_id" },
                       {
                          cascade_copy   => 0,
                          cascade_delete => 0
                       },
                     );

# Created by DBIx::Class::Schema::Loader v0.07033 @ 2012-09-17 10:14:02
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:/5IL+/aYGoZABi7+O3+CTQ

# ABSTRACT: table definition for DBIC schema for table REGIONS.

# You can replace this text with custom code or comments, and it will be preserved on regeneration
1;
