use utf8;

package App::Perf::Index::Schema::Result::PerformanceData;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY THE FIRST PART OF THIS FILE

=head1 NAME

App::Perf::Index::Schema::Result::PerformanceData

=cut

use strict;
use warnings;

use parent 'DBIx::Class::Core';

__PACKAGE__->load_components(qw{Helper::Row::ToJSON});

=head1 TABLE: C<PERFORMANCE_DATA>

=cut

__PACKAGE__->table("PERFORMANCE_DATA");

=head1 ACCESSORS

=head2 perf_id

  data_type: 'integer'
  is_auto_increment: 1
  is_nullable: 0

=head2 category_id

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 0

=head2 time_slice

  data_type: 'integer'
  is_nullable: 0

=head2 region_id

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 0

=head2 bucket00

  data_type: 'integer'
  is_nullable: 1

=head2 bucket01

  data_type: 'integer'
  is_nullable: 1

=head2 bucket02

  data_type: 'integer'
  is_nullable: 1

=head2 bucket03

  data_type: 'integer'
  is_nullable: 1

=head2 bucket04

  data_type: 'integer'
  is_nullable: 1

=head2 bucket05

  data_type: 'integer'
  is_nullable: 1

=head2 bucket06

  data_type: 'integer'
  is_nullable: 1

=head2 bucket07

  data_type: 'integer'
  is_nullable: 1

=head2 bucket08

  data_type: 'integer'
  is_nullable: 1

=head2 bucket09

  data_type: 'integer'
  is_nullable: 1

=head2 bucket10

  data_type: 'integer'
  is_nullable: 1

=head2 bucket11

  data_type: 'integer'
  is_nullable: 1

=head2 bucket12

  data_type: 'integer'
  is_nullable: 1

=head2 bucket13

  data_type: 'integer'
  is_nullable: 1

=head2 bucket14

  data_type: 'integer'
  is_nullable: 1

=head2 bucket15

  data_type: 'integer'
  is_nullable: 1

=head2 bucket16

  data_type: 'integer'
  is_nullable: 1

=head2 bucket17

  data_type: 'integer'
  is_nullable: 1

=head2 bucket18

  data_type: 'integer'
  is_nullable: 1

=head2 bucket19

  data_type: 'integer'
  is_nullable: 1

=cut

__PACKAGE__->add_columns(
                          "perf_id",
                          {
                             data_type         => "integer",
                             is_auto_increment => 1,
                             is_nullable       => 0
                          },
                          "category_id",
                          {
                             data_type      => "integer",
                             is_foreign_key => 1,
                             is_nullable    => 0
                          },
                          "time_slice",
                          {
                             data_type   => "integer",
                             is_nullable => 0
                          },
                          "region_id",
                          {
                             data_type      => "integer",
                             is_foreign_key => 1,
                             is_nullable    => 0
                          },
                          "bucket00",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket01",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket02",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket03",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket04",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket05",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket06",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket07",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket08",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket09",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket10",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket11",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket12",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket13",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket14",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket15",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket16",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket17",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket18",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                          "bucket19",
                          {
                             data_type   => "integer",
                             is_nullable => 1
                          },
                        );

=head1 PRIMARY KEY

=over 4

=item * L</perf_id>

=back

=cut

__PACKAGE__->set_primary_key("perf_id");

=head1 UNIQUE CONSTRAINTS

=head2 C<service_id_time_slice_region_id_category_unique>

=over 4

=item * L</category_id>

=item * L</time_slice>

=item * L</region_id>

=back

=cut

__PACKAGE__->add_unique_constraint( "category_id_time_slice_region_id_unique",
                                    [ "category_id", "time_slice", "region_id" ], );

=head1 RELATIONS

=head2 region

Type: belongs_to

Related object: L<App::Perf::Index::Schema::Result::Region>

=cut

__PACKAGE__->belongs_to(
                         "region",
                         "App::Perf::Index::Schema::Result::Region",
                         { region_id => "region_id" },
                         {
                            is_deferrable => 0,
                            on_delete     => "NO ACTION",
                            on_update     => "NO ACTION"
                         },
                       );

=head2 category

Type: belongs_to

Related object: L<App::Perf::Index::Schema::Result::Category>

=cut

__PACKAGE__->belongs_to(
                         "category",
                         "App::Perf::Index::Schema::Result::Category",
                         { category_id => "category_id" },
                         {
                            is_deferrable => 0,
                            on_delete     => "NO ACTION",
                            on_update     => "NO ACTION"
                         },
                       );

# Created by DBIx::Class::Schema::Loader v0.07033 @ 2012-09-17 10:14:02
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:NSdLweHHIQ1QpOhnV0pPTg

# ABSTRACT: table definition for DBIC schema for table PERFORMANCE_DATA.

# You can replace this text with custom code or comments, and it will be preserved on regeneration
1;
