use utf8;

package App::Perf::Index::Schema::Result::FetchRule;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY THE FIRST PART OF THIS FILE

=head1 NAME

App::Perf::Index::Schema::Result::FetchRule

=cut

use strict;
use warnings;

use parent 'DBIx::Class::Core';

__PACKAGE__->load_components(qw{Helper::Row::ToJSON});

=head1 TABLE: C<FETCH_RULES>

=cut

__PACKAGE__->table("FETCH_RULES");

=head1 ACCESSORS

=head2 fetch_id

  data_type: 'integer'
  is_auto_increment: 1
  is_nullable: 0

=head2 driver

  data_type: 'varchar'
  is_nullable: 0
  size: 256

=head2 username

  data_type: 'varchar'
  is_nullable: 0
  size: 32

=head2 password

  data_type: 'varchar'
  is_nullable: 0
  size: 32

=head2 attrs

  data_type: 'text'
  is_nullable: 0

=head2 query

  data_type: 'varchar'
  is_nullable: 0
  size: 256

=head2 required_mods

  data_type: 'text'
  is_nullable: 1

=cut

__PACKAGE__->add_columns(
                          "fetch_id",
                          {
                             data_type         => "integer",
                             is_auto_increment => 1,
                             is_nullable       => 0
                          },
                          "driver",
                          {
                             data_type   => "varchar",
                             is_nullable => 0,
                             size        => 256
                          },
                          "username",
                          {
                             data_type   => "varchar",
                             is_nullable => 0,
                             size        => 32
                          },
                          "password",
                          {
                             data_type   => "varchar",
                             is_nullable => 0,
                             size        => 32
                          },
                          "attrs",
                          {
                             data_type   => "text",
                             is_nullable => 0
                          },
                          "query",
                          {
                             data_type   => "varchar",
                             is_nullable => 0,
                             size        => 256
                          },
                          "required_mods",
                          {
                             data_type   => "text",
                             is_nullable => 1
                          },
                        );

=head1 PRIMARY KEY

=over 4

=item * L</fetch_id>

=back

=cut

__PACKAGE__->set_primary_key("fetch_id");

=head1 RELATIONS

=head2 services

Type: has_many

Related object: L<App::Perf::Index::Schema::Result::Service>

=cut

__PACKAGE__->has_many(
                       "services",
                       "App::Perf::Index::Schema::Result::Service",
                       { "foreign.fetch_id" => "self.fetch_id" },
                       {
                          cascade_copy   => 0,
                          cascade_delete => 0
                       },
                     );

# Created by DBIx::Class::Schema::Loader v0.07033 @ 2012-09-17 10:14:02
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:z+Vbn7kbr4iaeBmPsb3oAA

# ABSTRACT: table definition for DBIC schema for table FETCH_RULES.

# You can replace this text with custom code or comments, and it will be preserved on regeneration
1;
