use utf8;

package App::Perf::Index::Schema::Result::Category;

=head1 NAME

App::Perf::Index::Schema::Result::Category

=cut

use strict;
use warnings;

use parent 'DBIx::Class::Core';

__PACKAGE__->load_components(qw{Helper::Row::ToJSON});

=head1 TABLE: C<CATEGORIES>

=cut

__PACKAGE__->table("CATEGORIES");

=head1 ACCESSORS

=head2 category_id

  data_type: 'integer'
  is_auto_increment: 1
  is_nullable: 0

=head2 category_name

  data_type: 'varchar'
  is_nullable: 0
  size: 256

=head2 service_id

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 0

=head2 satisfy_threshold

  data_type: 'integer'
  is_nullable: 0

=head2 tolerable_threshold

  data_type: 'integer'
  is_nullable: 0


=cut

__PACKAGE__->add_columns(
                          "category_id",
                          {
                             data_type         => "integer",
                             is_auto_increment => 1,
                             is_nullable       => 0
                          },
                          "category_name",
                          {
                             data_type   => "varchar",
                             is_nullable => 0,
                             size        => 256
                          },
                          "service_id",
                          {
                             data_type      => "integer",
                             is_foreign_key => 1,
                             is_nullable    => 0
                          },
                          "satisfy_threshold",
                          {
                             data_type   => "integer",
                             is_nullable => 0
                          },
                          "tolerable_threshold",
                          {
                             data_type   => "integer",
                             is_nullable => 0
                          },
                        );

=head1 PRIMARY KEY

=over 4

=item * L</category_id>

=back

=cut

__PACKAGE__->set_primary_key("category_id");

=head1 RELATIONS

=head2 performance_datas

Type: has_many

Related object: L<App::Perf::Index::Schema::Result::PerformanceData>

=cut

__PACKAGE__->has_many(
                       "performance_datas",
                       "App::Perf::Index::Schema::Result::PerformanceData",
                       { "foreign.category_id" => "self.category_id" },
                       {
                          cascade_copy   => 0,
                          cascade_delete => 0
                       },
                     );

=head2 service

Type: belongs_to

Related object: L<App::Perf::Index::Schema::Result::Service>

=cut

__PACKAGE__->belongs_to(
                         "service",
                         "App::Perf::Index::Schema::Result::Service",
                         { service_id => "service_id" },
                         {
                            is_deferrable => 0,
                            on_delete     => "NO ACTION",
                            on_update     => "NO ACTION"
                         },
                       );

# Created by DBIx::Class::Schema::Loader v0.07033 @ 2012-09-17 10:14:02
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:z+Vbn7kbr4iaeBmPsb3oAA

# ABSTRACT: table definition for DBIC schema for table CATEGORIES.

# You can replace this text with custom code or comments, and it will be preserved on regeneration
1;
