package App::Perf::Index;

use v5.14;
use strictures;

use Data::Dumper;

# ABSTRACT: common routines for Application Performance Index

=begin private

sub _do_select
{
    my ( $self, $dbh, $sql, @params ) = @_;

    Dancer::debug( "sql: ", $sql, " -- params:", \@params );
    my $sth = $dbh->prepare($sql) or die "Can't prepare '$sql': " . $dbh->errstr();
    $sth->execute(@params) or die "Can't execute '$sql': " . $dbh->errstr();
    my $rows = $sth->fetchall_arrayref();
    Dancer::debug( "rows: ", $rows );

    return $rows;
}

sub _build_where_clauses
{
    map +(
           @{ $_->[1] }
           ? ( "$_->[0] IN (" . join( ",", ("?") x scalar( @{ $_->[1] } ) ) . ")" )
           : ()
         ),
      @_;
}

sub _get_services
{
    my ( $self, $dbh, $service_names ) = @_;

    $service_names //= [];
    my $sql =
      "SELECT SERVICE_ID, SERVICE_NAME, SATISFY_THRESHOLD, TOLERABLE_THRESHOLD FROM SERVICES";
    my @where = _build_where_clauses( [ SERVICE_NAME => $service_names ] );
    @where and $sql = join( " WHERE ", $sql, join( " AND ", @where ) );
    my $rows = $self->_do_select( $dbh, $sql, @$service_names );

    $rows;
}

sub _get_service_ids
{
    my ( $self, $dbh, $service_names ) = @_;

    $service_names //= [];
    my $sql = "SELECT SERVICE_ID, SERVICE_NAME FROM SERVICES";
    my @where = _build_where_clauses( [ SERVICE_NAME => $service_names ] );
    @where and $sql = join( " WHERE ", $sql, join( " AND ", @where ) );
    my $service_ids = $self->_do_select( $dbh, $sql, @$service_names );

    $service_ids;
}

sub _get_service_categories
{
    my ( $self, $dbh, $service_names ) = @_;

    $service_names //= [];
    my $sql = join( " ",
                    "SELECT DISTINCT",
                    "PERFORMANCE_DATA.SERVICE_ID, SERVICES.SERVICE_NAME, PERFORMANCE_DATA.CATEGORY",
                    "FROM PERFORMANCE_DATA, SERVICES" );
    my @where = _build_where_clauses( [ SERVICE_NAME => $service_names ] );
    push( @where, "PERFORMANCE_DATA.SERVICE_ID=SERVICES.SERVICE_ID" );
    @where and $sql = join( " WHERE ", $sql, join( " AND ", @where ) );

    my $rows = $self->_do_select( $dbh, $sql, @$service_names );
    # [ map +( [ $_->[0], $services_by_id{ $_->[0] }, $_->[1] ] ), @$rows ];
    $rows;
}

sub _get_service_regions
{
    my ( $self, $dbh, $service_names, $categories ) = @_;

    $service_names //= [];
    $categories    //= [];
    my $sql = join( " ",
        "SELECT DISTINCT",
        "PERFORMANCE_DATA.SERVICE_ID, SERVICES.SERVICE_NAME, PERFORMANCE_DATA.CATEGORY, REGIONS.ALPHA2_CODE",
        "FROM PERFORMANCE_DATA, REGIONS, SERVICES" );
    my @where =
      _build_where_clauses( [ SERVICE_NAME => $service_names ], [ CATEGORY => $categories ] );
    push( @where, "PERFORMANCE_DATA.REGION_ID=REGIONS.REGION_ID" );
    push( @where, "PERFORMANCE_DATA.SERVICE_ID=SERVICES.SERVICE_ID" );
    @where and $sql = join( " WHERE ", $sql, join( " AND ", @where ) );

    my $rows = $self->_do_select( $dbh, $sql, @$service_names, @$categories );
    # [ map +( [ $_->[0], $services_by_id{ $_->[0] }, $_->[1], $_->[2] ] ), @$rows ];
    $rows;
}

sub _get_service_time_specs
{
    my ( $self, $dbh, $service_names, $categories, $regions ) = @_;

    $service_names //= [];
    $categories    //= [];
    $regions       //= [];
    my $sql = join( " ",
                    "SELECT",
                    "PERFORMANCE_DATA.SERVICE_ID, SERVICES.SERVICE_NAME,",
                    "PERFORMANCE_DATA.CATEGORY, REGIONS.ALPHA2_CODE,",
                    "MIN(TIME_SLICE), MAX(TIME_SLICE)",
                    "FROM PERFORMANCE_DATA, REGIONS, SERVICES" );
    my @where = _build_where_clauses(
                                      [ SERVICE_NAME          => $service_names ],
                                      [ CATEGORY              => $categories ],
                                      [ "REGIONS.ALPHA2_CODE" => $regions ]
                                    );
    push( @where, "PERFORMANCE_DATA.REGION_ID=REGIONS.REGION_ID" );
    @where and $sql = join( " WHERE ", $sql, join( " AND ", @where ) );
    $sql .= " GROUP BY PERFORMANCE_DATA.SERVICE_ID, PERFORMANCE_DATA.CATEGORY, REGIONS.ALPHA2_CODE";

    my $rows = $self->_do_select( $dbh, $sql, @$service_names, @$categories, @$regions );
    # [ map +( [ $_->[0], $services_by_id{ $_->[0] }, $_->[1], $_->[2], $_->[3], $_->[4] ] ), @$rows ];
    $rows;
}

sub _get_service_buckets
{
    my ( $self, $dbh, $service_names, $categories, $regions, $time_spec ) = @_;

    $service_names //= [];
    $categories    //= [];
    $regions       //= [];
    $time_spec     //= [];
    my $sql = join( " ",
                    "SELECT",
                    "PERFORMANCE_DATA.SERVICE_ID, SERVICES.SERVICE_NAME,",
                    "PERFORMANCE_DATA.CATEGORY, REGIONS.ALPHA2_CODE,",
                    join( ", ", ( map +("SUM($_)"), ( "BUCKET00" .. "BUCKET19" ) ) ),
                    "FROM PERFORMANCE_DATA, REGIONS, SERVICES" );
    my @where = _build_where_clauses(
                                      [ SERVICE_NAME          => $service_names ],
                                      [ CATEGORY              => $categories ],
                                      [ "REGIONS.ALPHA2_CODE" => $regions ]
                                    );
    given ( scalar(@$time_spec) )
    {
        when (0) { }
        when (1) { push( @where, "TIME_SLICE>=?" ) }
        when (2) { push( @where, "TIME_SLICE BETWEEN ? AND ?" ) }
        default  { die "to much elements time spec" }
    }
    push( @where, "PERFORMANCE_DATA.REGION_ID=REGIONS.REGION_ID" );
    @where and $sql = join( " WHERE ", $sql, join( " AND ", @where ) );
    $sql .= " GROUP BY PERFORMANCE_DATA.SERVICE_ID, PERFORMANCE_DATA.CATEGORY, REGIONS.ALPHA2_CODE";

    my $rows =
      $self->_do_select( $dbh, $sql, @$service_names, @$categories, @$regions, @$time_spec );
    # [ map +( [ $_->[0], $services_by_id{ $_->[0] }, $_->[ 1 .. $#$_ ] ] ), @$rows ];
    $rows;
}

=end private

=cut

sub _replace_var_in_list
{
    my ( $self, $var, $val, $str, $ary ) = @_;

    foreach my $item (@$ary)
    {
        $item or next;

        ref($item) eq 'ARRAY' and $self->_replace_var_in_list( $var, $val, $str, $item ) and next;
        ref($item) eq 'HASH' and $self->_replace_var_in_hash( $var, $val, $str, $item ) and next;

        ref($val) and $item eq $var and $item = $val and next;
        $item =~ s/\b\Q$var\E\b/$str/g;
    }

    1;
}

sub _replace_var_in_hash
{
    my ( $self, $var, $val, $str, $hash ) = @_;

    foreach my $key ( keys %$hash )
    {
        $hash->{$key} or next;

        ref( $hash->{$key} ) eq 'ARRAY'
          and $self->_replace_var_in_list( $var, $val, $str, $hash->{$key} )
          and next;
        ref( $hash->{$key} ) eq 'HASH'
          and $self->_replace_var_in_hash( $var, $val, $str, $hash->{$key} )
          and next;

        ref($val) and $hash->{$key} eq $var and $hash->{$key} = $val and next;
        $hash->{$key} =~ s/\b\Q$var\E\b/$str/g;
    }

    1;
}

sub _replace_vars
{
    my ( $self, $vars, $hash ) = @_;

    foreach my $var ( keys %$vars )
    {
        my $val = $vars->{$var};
        if ( $val =~ m/^eval\s+/ )
        {
            $val =~ s/^eval\s+//;
            $val = eval $val;
        }

        my $str =
          ref($val)
          ? Data::Dumper->new( [$val] )->Indent(0)->Sortkeys(1)->Quotekeys(0)->Terse(1)->Dump()
          : $val;
        $self->_replace_var_in_hash( $var, $val, $str, $hash );
    }

    return;
}

1;
