/*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	PICOPBC_ATTRIBUTE_H
#define	PICOPBC_ATTRIBUTE_H

#ifdef __GNUC__
#define	GNUC_PREREQ(maj, min)						      \
	((__GNUC__ > (maj)) ||						      \
	 ((__GNUC__ == (maj)) && (__GNUC_MINOR__ >= (min))))
#else
#define	GNUC_PREREQ(maj, min)	0
#endif

#if GNUC_PREREQ(2,5)
#define	attr_constfunc	__attribute__((__const__))
#else
#define	attr_constfunc
#endif

#if GNUC_PREREQ(2,5)
#define	attr_noreturn	__attribute__((__noreturn__))
#else
#define	attr_noreturn
#endif

#if GNUC_PREREQ(2,7)
#define	attr_printflike(fmt, var)					      \
	__attribute__((__format__(__printf__, fmt, var)))
#else
#define	attr_printflike(fmt, var)	/* nothing */
#endif

#if GNUC_PREREQ(2,7)
#define	attr_unused	__attribute__((__unused__))
#else
#define	attr_unused
#endif

#endif	/* PICOPBC_ATTRIBUTE_H */
