import sys
import mmap
import timeit
sys.path.append('/home/joerg/work/Infrastructure/hg')

import mercurial.ui, mercurial.localrepo, timeit, mercurial.revlog, mercurial.policy

ui = mercurial.ui.ui()

def check_phash(node):
    repo = mercurial.localrepo.makelocalrepository(ui, b'.')
    phf = open('.hg/store/00changelog.i.phf', 'rb')
    buf = mmap.mmap(phf.fileno(), 0, mmap.MAP_PRIVATE, mmap.PROT_READ)
    phash = mercurial.revlog.parsers.phash(buf, repo.changelog.index)
    return phash.get(node)

def regular_nodemap(node):
    repo = mercurial.localrepo.makelocalrepository(ui, b'.')
    return repo.changelog.index.get_rev(node)

node = bytes.fromhex('0849d280663e46b3e247857f4a68fabd2ba503c3')

if mercurial.policy.policy != b'rust+c':
    assert check_phash(node) == regular_nodemap(node)

runs = 1000
factor = 1000
print ('current policy:', mercurial.policy.policy)
if mercurial.policy.policy != b'rust+c':
    print ('phash:         ', factor * timeit.timeit(lambda: check_phash(node), setup='gc.enable()', number=runs), '/m')

# very slow, hack it into something manageable
if mercurial.policy.policy == b'py':
    factor = 100000
    runs = 10
print ('regular lookup:', factor * timeit.timeit(lambda: regular_nodemap(node), setup='gc.enable()', number=runs), '/m')
