import sys
import mmap
import timeit
sys.path.append('/home/joerg/work/Infrastructure/hg')

import mercurial.ui, mercurial.localrepo, timeit, mercurial.revlog, mercurial.policy

ui = mercurial.ui.ui()

repo = mercurial.localrepo.makelocalrepository(ui, b'.')
if mercurial.policy.policy != b'rust+c':
    phf = open('.hg/store/00changelog.i.phf', 'rb')
    buf = mmap.mmap(phf.fileno(), 0, mmap.MAP_PRIVATE, mmap.PROT_READ)
    phash = mercurial.revlog.parsers.phash(buf, repo.changelog.index)

def check_phash(node):
    return phash.get(node)

def regular_nodemap(node):
    return repo.changelog.index.get_rev(node)

node = bytes.fromhex('0849d280663e46b3e247857f4a68fabd2ba503c3')

if mercurial.policy.policy != b'rust+c':
    assert check_phash(node) == regular_nodemap(node)

runs = 1000000
print ('current policy:', mercurial.policy.policy)
if mercurial.policy.policy != b'rust+c':
    print ('phash:         ', timeit.timeit(lambda: check_phash(node), setup='gc.enable()', number=runs), '/m')
print ('regular lookup:', timeit.timeit(lambda: regular_nodemap(node), setup='gc.enable()', number=runs), '/m')
