/*
 * Professional Galactic Empires Client
 * Copyright 1996-1999 David A. Holland
 * Version 0.1, 6/11/99
 * All rights reserved.
 *
 * See the included file "COPYING" for license information.
 */

/*
 * pge client, take 2.
 */

#include <sys/types.h>
#include <sys/time.h>  // posix for select()
#include <sys/socket.h>
#include <pwd.h>
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <termios.h>
#include <sys/ioctl.h>

#include "ptrarray.h"
#include "pgeclient.h"
#include "util.h"

static int waitqueuepos=-1;
//static ptrarray<char> databuf;

//static void clear_databuf() {
//    for (int i=0; i<databuf.num(); i++) delete databuf[i];
//    databuf.setsize(0);
//}

void process_net_line(const char *line) {
    static int data_coming = 0;

    if (data_coming) {
	if (!strcmp(line, ".")) {
	    data_coming = 0;
	    say("");
	}
	else {
	    if (*line=='.') line++;
	    //databuf.add(xstrdup(line));
	    say("%s", line);
	}
	return;
    }

    int code = atoi(line);
    const char *x = strchr(line, ' ');
    int code2 = x ? atoi(x) : -1;

    switch (code) {
      case 120: 
	  waitqueuepos = 0;
	  display_setplayable(1);
	  say("Ready to play.");
	  break;
      case 121:
      case 421:
	  waitqueuepos = code2;
	  display_setplayable(0);
	  if (waitqueuepos != 1) {
	     say("There are %d people ahead of you.", waitqueuepos);
	  }
	  else {
	     say("There is 1 person ahead of you.");
	  }
	  break;
      case 200:
	  tell("VERSION 2\r\n");
	  break;
      case 210:
      case 211:
      case 411:
      case 511:
	  /* not supported */
	  break;
      case 221:
	  set_linemode(0);
	  display_setplaying(1);
	  break;
      case 232:
	  data_coming = 1;
	  //clear_databuf();
	  say("");
	  break;
      case 250:
	  if (waitqueuepos<0) tell("QUEUE\r\n");
	  break;
      case 302:
	  say("Warning: we are out of date, better get a newer client");
	  break;
      case 401:
	  say("Server unavailable:%s", x);
	  //tell("QUIT\r\n");
	  break;
      case 500:
      case 501:
	  say("Server syntax error (please report what caused this)");
	  break;
      case 502:
	  say("The server does not support this client version.");
	  say("Cannot continue...");
	  tell("QUIT\r\n");
	  break;
      case 510:
	  say("Permission denied");
	  break;
      case 532:
	  say("Requested information not available");
	  break;
    }

    display_setqueuepos(waitqueuepos);
}

/*
 * Interpret the following vt100 codes (the only ones pge sends):
 *    esc[0m
 *    esc[0;1m
 *    esc[0;7m
 *    esc[2J
 *    esc[K
 *
 *    esc -> bracket -> 0 -> m
 *                        -> ; -> 1 -> m
 *                             -> 7 -> m
 *                   -> 2 -> J
 *                   -> K
 */

#define ST_NORMAL  1
#define ST_GOTESC  2
#define ST_GOTLBR  3
#define ST_GOT0    4
#define ST_GOT2    5
#define ST_GOTSEM  6
#define ST_GOT1    7
#define ST_GOT7    8

#define ACT_NONE   0
#define ACT_TEXT   1
#define ACT_BOLD   2
#define ACT_REV    3
#define ACT_CLRSCR 4
#define ACT_CLREOL 5

static const struct {
    int state, ch, newstate, action;
} statetable[] = {
    { ST_NORMAL, 27,  ST_GOTESC },
    { ST_GOTESC, '[', ST_GOTLBR },
    { ST_GOTLBR, '0', ST_GOT0 },
    { ST_GOTLBR, '2', ST_GOT2 },
    { ST_GOTLBR, 'K', ST_NORMAL, ACT_CLREOL },
    { ST_GOT0,   'm', ST_NORMAL, ACT_TEXT },
    { ST_GOT0,   ';', ST_GOTSEM },
    { ST_GOT2,   'J', ST_NORMAL, ACT_CLRSCR },
    { ST_GOTSEM, '1', ST_GOT1 },
    { ST_GOTSEM, '7', ST_GOT7 },
    { ST_GOT1,   'm', ST_NORMAL, ACT_BOLD },
    { ST_GOT7,   'm', ST_NORMAL, ACT_REV },
    { 0 }
};

static int process_net_char(int ch) {
    static int ctrldcount = 0;
    static int state = ST_NORMAL;

    if (ch==4) {
	ctrldcount++;
	if (ctrldcount==72) {
	    ctrldcount = 0;
	    state = ST_NORMAL;
	    set_linemode(1);
	    display_setplaying(0);
	    return -1;
	}
	return 0;
    }
    ctrldcount = 0;

    for (int i=0; statetable[i].state; i++) {
	if (statetable[i].state == state && statetable[i].ch == ch) {
	    state = statetable[i].newstate;
	    int act = statetable[i].action;
	    switch (act) {
	      case ACT_TEXT: display_text(); break;
	      case ACT_BOLD: display_bold(); break;
	      case ACT_REV: display_reverse(); break;
	      case ACT_CLRSCR: break;
	      case ACT_CLREOL: break;
	    }
	    return 0;
	}
    }

    if (state==ST_NORMAL) display_char(ch);
    return 0;
}

void process_net_data(const char *buf, size_t len) {
    for (size_t i=0; i<len; i++) {
	if (process_net_char(buf[i])) break;
    }
}
