/*
 * Professional Galactic Empires Client
 * Copyright 1996-1999 David A. Holland
 * Version 0.1, 6/11/99
 * All rights reserved.
 *
 * See the included file "COPYING" for license information.
 */

//
// pge client utils.
//

#include <assert.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>   /* for COMPILE_VSNPRINTF */
#include "util.h"

char *xstrdup(const char *s) {
    return strcpy(new char[strlen(s)+1], s);
}

short *xstrdup(const short *s) {
    int len;
    for (len=0; s[len]; len++);
    len++;
    short *x = new short[len];
    for (int i=0; i<len; i++) x[i] = s[i];
    return x;
}

long *xstrdup(const long *s) {
    int len;
    for (len=0; s[len]; len++);
    len++;
    long *x = new long[len];
    for (int i=0; i<len; i++) x[i] = s[i];
    return x;
}

#ifdef COMPILE_VSNPRINTF
/*
 * Do not use this as a general snprintf implementation, because it is
 * not sufficiently secure.
 */
int vsnprintf(char *buf, size_t len, const char *fmt, va_list ap) {
  static char foo[8192];
  assert(len < sizeof(foo));
  assert(len>0);
  int r = vsprintf(foo, fmt, ap); 
  assert(strlen(foo)<sizeof(foo));
  foo[len-1] = 0;
  strcpy(buf, foo);
  return r;
}

int snprintf(char *buf, size_t len, const char *fmt, ...) {
    va_list ap;
    va_start(ap, fmt);
    int rv = vsnprintf(buf, len, fmt, ap);
    va_end(ap);
    return rv;
}
#endif
