(*
 * Copyright (c) 2018-2019
 *	The President and Fellows of Harvard College.
 *
 * Written by David A. Holland.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *)

(*
 * clearinghouse for operating modes to be tinkered with
 *)

(**************************************************************)
(* encoding of machine ints *)

type smt_mint_modes =
     (* machine ints are bitvectors *)
   | MINT_AS_BV
     (* machine ints are ints; convert to bitvectors for bitops *)
   | MINT_AS_INT_CONVERT
     (* machine ints are ints; bitops are uninterpreted functions *)
   | MINT_AS_INT_BITFUNC
     (* machine ints are ints; all ops are uninterpreted functions *)
   | MINT_AS_INT_ALLFUNC
     (* machine ints are ints always in the u32 range;
        all ops are uninterpreted functions *)
(* XXX notyet
   | MINT_AS_U32_ALLFUNC
*)

let smt_mint_mode = MINT_AS_BV

let mints_are_bitvectors =
   match smt_mint_mode with
   | MINT_AS_BV -> true
   | _ -> false

(**************************************************************)
(* encoding of logic ints (thus enumerations) *)

let xints_are_bitvectors = true

(**************************************************************)
(* encoding of register file *)

(*
 * 20210311 dholland: ripped this out as it's making a mess and it was
 * a negative result. Might put the support back later after internal
 * cleanup, but more likely it's not worthwhile.
 *)
(*
type smt_register_modes =
   | REGS_VIA_VARS
   | REGS_VIA_ARRAYEQS
   | REGS_VIA_ARRAYSTORES

let smt_register_mode = REGS_VIA_VARS

let registers_use_vars = smt_register_mode = REGS_VIA_VARS
*)