val nl: Lexing.lexbuf -> unit
val advance: Lexing.lexbuf -> unit
val pos: Lexing.lexbuf -> Pos.pos
val posval: Lexing.lexbuf -> (Pos.pos * string)
val tval: Lexing.lexbuf -> string
val tval': Lexing.lexbuf -> (string -> 'a) -> 'a

val startstring: Lexing.lexbuf -> unit
val addstring: string -> unit
val addchar: char -> unit
val getstring: unit -> string

val doident': ('t Types.StringMap.t) -> (string -> 't) -> string -> 't

val badchar: (Pos.pos * string) -> 't
val badstring: Pos.pos -> unit

val addincludepath: string -> unit
val includefile: string -> unit

val read':
	(Lexing.lexbuf -> 't) ->				(* lexer *)
	((Lexing.lexbuf -> 't) -> Lexing.lexbuf -> 'r) ->	(* parser *)
	't ->							(* eof *)
	('t -> bool) ->						(* iseof *)
	('t -> string) ->					(* dumpone *)
	('r -> 'r) ->						(* check *)
	string ->						(* pathname *)
	'r							(* result *)
