(*
 * Copyright (c) 2018-2019
 *	The President and Fellows of Harvard College.
 *
 * Written by David A. Holland.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *)

type bop =
   | IMPLIES
   | LOGOR | LOGXOR | LOGAND
   | BITOR | BITXOR | BITAND
   | EQ | NEQ
   | LT | LTEQ | GT | GTEQ
   | SHL | SHR
   | ADD | SUB
   | MUL | DIV | MOD

type uop =
   | LOGNOT | BITNOT | NEG | WIDEN | TOSIGNED | TOUNSIGNED

type expr =
   | FORALL of string * expr
   | EXISTS of string * expr
   | LET of expr * string * expr
   | BOP of bop * expr * expr
   | UOP of uop * expr
   | READQUALFUNC of string * string * expr
   | READQUAL of string * string
   | READVAR of string
   | INTCONST of int

type sketchoperand = string * expr list
type sketchinsn = int * sketchoperand list

type sketchentry =
   | ANYTHING
   | CHOICES of sketchinsn list

type sketch = sketchentry list
