/*-
 * Copyright (c) 2012 Alistair Crooks <agc@NetBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>

#include <err.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "xzmem.h"

/* quick'n'dirty "is it working?" program */

int
main(int argc, char **argv)
{
	size_t	 outcc;
	size_t	 zcc;
	FILE	*fp;
	uint8_t	 outbuf[10 * 1024];
	uint8_t	 inbuf[10 * 1024];
	uint8_t	 zbuf[10 * 1024];
	int	 i;

	while ((i = getopt(argc, argv, "")) != -1) {
	}
	if (optind < argc) {
		if ((fp = fopen(argv[optind], "r")) == NULL) {
			warn("can't open words");
			return 1;
		}
	} else {
		fp = stdin;
	}
	if (fread(inbuf, 1, sizeof(inbuf), fp) > 0) {
		outcc = sizeof(zbuf);
		xz_compress(zbuf, &outcc, inbuf, sizeof(inbuf));
		zcc = outcc;
		outcc = sizeof(outbuf);
		xz_decompress(outbuf, &outcc, zbuf, zcc);
		if (memcmp(outbuf, inbuf, sizeof(inbuf)) != 0) {
			printf("unmatched lzma compression - bollocks\n");
		}
	}
	return 0;
}
