/*
  Copyright (c) 2010 Alistair Crooks (agc@pkgsrc.org)

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "mj.h"

int
main(int argc, char **argv)
{
	char	 uidbuf[32 + 1];
	char	 sigbuf[32 + 1];
	char	 buf[32 + 1];
	char	*s;
	mj_t	 uids_array;
	mj_t	 key_obj;
	int	 i;
	int	 j;

	(void) memset(&uids_array, 0x0, sizeof(uids_array));
	(void) memset(&key_obj, 0x0, sizeof(key_obj));
	mj_create(&key_obj, "object");
	mj_append(&key_obj, "string", "fingerprint");
	mj_append(&key_obj, "string", "d415 9deb 336d e4cc cdfa 00cd 1b68 dcfc c059 6823");
	mj_append(&key_obj, "string", "expired");
	mj_append(&key_obj, "string", "[EXPIRED 2010-06-01]");
	mj_create(&uids_array, "array");
	for (i = 0 ; i < 6 ; i++) {
		mj_t	 sigs_array;

		(void) memset(&sigs_array, 0x0, sizeof(sigs_array));
		(void) memset(buf, '0' + i, sizeof(buf) - 1);
		buf[sizeof(buf) - 1] = 0x0;
		(void) snprintf(uidbuf, sizeof(uidbuf), "uid%d", i);
		mj_append(&uids_array, "string", buf);
		mj_create(&sigs_array, "array");
		for (j = 0 ; j < 4 ; j++) {
			mj_t	sig;

			(void) memset(&sig, 0x0, sizeof(sig));
			mj_create(&sig, "object");
			(void) snprintf(sigbuf, sizeof(sigbuf), "signer%d", j);
			mj_append(&sig, "string", "signer");
			mj_append(&sig, "string", sigbuf);
			mj_append(&sig, "string", "time");
			mj_append(&sig, "string", "1999-09-02");
			(void) snprintf(sigbuf, sizeof(sigbuf), "truster%d", j);
			mj_append(&sig, "string", "trustkey");
			mj_append(&sig, "string", sigbuf);
			mj_append(&sigs_array, "object", &sig);
			mj_delete(&sig);
		}
		mj_append(&uids_array, "array", &sigs_array);
		mj_delete(&sigs_array);
	}
	mj_append(&key_obj, "string", "uids");
	mj_append(&key_obj, "array", &uids_array);
	(void) mj_asprint(&s, &key_obj);
	printf("%s", s);
	exit(0);
}
