/*
  Copyright (c) 2010 Alistair Crooks (agc@pkgsrc.org)

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "mj.h"
#include "defs.h"

static int
test(const char *text)
{
	mj_t	 atom;
	char	*s;
	int	 size;

	(void) memset(&atom, 0x0, sizeof(atom));
	size = 0;
	mj_parse(&atom, text, &size);
	size = mj_asprint(&s, &atom);
	mj_delete(&atom);
	printf("%s\n", s);
	free(s);
	return 0;
}

int
main(int argc, char **argv)
{
	test("{ \"name\": \"object1\", \"size\": 1786909, \"length\":1234, \"height\": 5678 }");
	test("[ \"name\", \"object1\", \"size\", 1786909, \"length\", 1234, \"height\", 5678 ]");
	test("{ \"name\": \"object1\", \"size\": 1786909, \"length\":1234, \"height\": 5678, \"width\": 12345678901234567890, \"transparent\":false }");
	exit(EXIT_SUCCESS);
}
