#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include <arpa/inet.h>

#include "tiger.h"

#ifdef i386
#define ITERATIONS 30
#else
#define ITERATIONS 500
#endif

int
main(int argc, char **argv)
{
	uint8_t buffer[65536];
	char sum[49];
	long t1;
	long t2;
	double rate;
	int i;

#define hash(str, len) TIGER_Data((const uint8_t *)str, (len < 0) ? strlen(str) : (size_t)len, sum); \
	printf("Hash of \"%s\":\n\t%s\n", (len < 0) ? str : "", sum);

	while ((i = getopt(argc, argv, "")) != -1) {
	}
	/* Hash of short strings */
	hash("", -1);
	hash("abc", -1);
	hash("Tiger", -1);
	hash("The quick brown fox jumps over the lazy dog", -1);
	/* Hash of 512-bit strings */
	hash("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-", -1);
	hash("ABCDEFGHIJKLMNOPQRSTUVWXYZ=abcdefghijklmnopqrstuvwxyz+0123456789", -1);
	hash("Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham", -1);
	/* Hash of two-block strings strings */
	hash("Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, proceedings of Fast Software Encryption 3, Cambridge.", -1);
	hash("Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, proceedings of Fast Software Encryption 3, Cambridge, 1996.", -1);
	hash("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-", -1);

	/* Hash of a 64K byte string */
	for (i=0;i<65536;i++)
		buffer[i] = i&0xFF;

	//tiger(buffer, 65536, res);
	hash((char *)buffer, 65536);

	t1 = clock();
	for (i=0;i<ITERATIONS;i++) {
		TIGER_Data(buffer, 65536, sum);
	}
	t2 = clock();

	rate = (double)CLOCKS_PER_SEC*(double)ITERATIONS*65556.0*8.0/
		((double)(t2 - t1));
	printf("rate = %lf bit/s\n", rate);
	exit(EXIT_SUCCESS);
}
