/*-
 * Copyright (c) 2010 Alistair Crooks <agc@NetBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <atf-c.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <strcodecs.h>

ATF_TC(base64);
ATF_TC_HEAD(base64, tc)
{
	atf_tc_set_md_var(tc, "descr",
		 "test cases for base64 in the strcodecs library");
}
ATF_TC_BODY(base64, tc)
{
	strcodecs_t	 codecs;
	size_t		 asize;
	size_t		 bsize;
	size_t		 nsize;
	char		*nbuf;
	char		*abuf;
	char		 buf[256];
	int		 ac;
	int		 bc;
	int		 nc;

	(void) memset(&codecs, 0x0, sizeof(codecs));
	bc = snprintf(buf, sizeof(buf), "anuddER FINE mess YOU GOT ME in");
	ac = astrcodec(&codecs, buf, bc, "btoa", &abuf, &asize);
	nc = astrcodec(&codecs, abuf, ac, "atob", &nbuf, &nsize);
	ATF_CHECK_STREQ_MSG(buf, nbuf, "%s contents incorrect");
	ATF_CHECK_EQ_MSG(bc, nc, "%s sizes incorrect");
}

ATF_TC(base85);
ATF_TC_HEAD(base85, tc)
{
	atf_tc_set_md_var(tc, "descr",
		 "test cases for base85 in the strcodecs library");
}
ATF_TC_BODY(base85, tc)
{
	strcodecs_t	 codecs;
	size_t		 asize;
	size_t		 bsize;
	size_t		 nsize;
	char		*nbuf;
	char		*abuf;
	char		 buf[256];
	int		 ac;
	int		 bc;
	int		 nc;

	(void) memset(&codecs, 0x0, sizeof(codecs));
	bc = snprintf(buf, sizeof(buf), "anuddER FINE mess YOU GOT ME in");
	ac = astrcodec(&codecs, buf, bc, "base85encode", &abuf, &asize);
	nc = astrcodec(&codecs, abuf, ac, "base85decode", &nbuf, &nsize);
	ATF_CHECK_STREQ_MSG(buf, nbuf, "%s contents incorrect");
	ATF_CHECK_EQ_MSG(bc, nc, "%s sizes incorrect");
}


ATF_TP_ADD_TCS(tp)
{
	ATF_TP_ADD_TC(tp, base64);
	ATF_TP_ADD_TC(tp, base85);

	return atf_no_error();
}
