/*-
 * Copyright (c) 2010 Alistair Crooks <agc@NetBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef CODECS_H_
#define CODECS_H_	20091223

#include <sys/types.h>

#include <regex.h>

/* structure to lay out what translations we can do */
typedef struct codec_t {
	char	 *op;		/* string representing operation */
	int	(*func)(const char *, const size_t, const char *, void *, size_t);
	char	 *multiplier;	/* size needed as percentage */
	regex_t	 *r;		/* compiled regexp to match against */
	int	inputneeded;	/* an error if there's no input buffer */
} codec_t;

/* structure which holds dynamic array of codecs */
typedef struct codecs_t {
	unsigned	 flags;	/* misc flags */
	unsigned	 c;	/* # in array */
	unsigned	 size;	/* size of allocated array */
	codec_t	*v;	/* the array of codecs */
	uint64_t	 locked; /* the array has been locked */
} codecs_t;

int codecs_transform(codecs_t *, const char *, const size_t, const char *, void *, size_t);
int codecs_alloc_transform(codecs_t *, const char *, const size_t, const char *, void *, size_t *);
int codecs_inplace_transform(codecs_t *, void *, int, const char *);

int codecs_size(codecs_t *, const char *, const unsigned);
int codecs_input_needed(codecs_t *, const char *);
int codecs_valid_op(codecs_t *, const char *);

int codecs_add(codecs_t *, const char *,
	int(*)(const char *, const size_t, const char *, void *, size_t),
	const char *, const int);

int codecs_lockdown(codecs_t *);

int codecs_begin(codecs_t *, const char *, ...);
int codecs_end(codecs_t *);

#endif
