/*	$Id: saostreg.h,v 1.4 2001/02/16 17:55:16 ichiro Exp $ */

/*	$NetBSD: chio.h,v 1.10 1999/09/09 23:24:11 thorpej Exp $	*/

/*-
 * Copyright (c) 2001 The NetBSD Foundation, Inc.  All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Ichiro FUKUHARA.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * SA-1110 has 4ch timer register
 */

/* #define SAOST_HW_BASE           0x90000000 */

/* size of I/O space */
#define OST_NPORTS	8

/* OS Timer Match Register */
#define OST_OSMR0	0	/* 0x90000000 */
#define OST_OSMR1	1	/* 0x90000004 */
#define OST_OSMR2	2	/* 0x90000008 */
#define OST_OSMR3	3	/* 0x9000000C */

/* OS Timer Count Register */
#define OST_OSCR	4	/* 0x90000010 */

/* OS Timer Status Register */
#define OST_OSSR	5	/* 0x90000014 */
#define OSSR_CH0	(1<<0)
#define OSSR_CH1	(1<<1)
#define OSSR_CH2	(1<<2)
#define OSSR_CH3	(1<<3)

/* OS Timer Watchdog Match Enable Register */
#define OST_OWER	6	/* 0x90000018 */

/* OS Timer Interrupt Enable Register */
#define OST_OIER	7	/* 0x9000001C */

/*
 * SA-1110 Real Time Clock
 */

/* RTC Counter Register */
#define SA_RCNR		0x90010004

/* RTC Alarm Register */
#define SA_RTAR		0x90010000

/* RTC Status Register */
#define SA_RTSR		0x90010010

/* RTC Trim Register */
#define SA_RTTR		0x90010008

/* end of saostreg.h */
