/*	$Id: salcd.c,v 1.3 2001/02/17 05:18:38 ichiro Exp $ */

/*	$NetBSD: $	*/
/*
 * Copyright (c) 2001 Ichiro FUKUHARA. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/time.h>
#include <sys/device.h>

#include <machine/bus.h>
#include <machine/irqhandler.h>
#include <machine/cpufunc.h>
#include <machine/katelib.h>

#include <hpcarm/sa/saipreg.h> 
#include <hpcarm/sa/saipvar.h>
#include <hpcarm/sa/salcdreg.h>

struct salcd_softc {
	struct device sc_dev;
	bus_space_tag_t sc_iot;
	bus_space_handle_t sc_ioh;
};

static struct salcd_softc *salcd_sc;

static int salcd_match   __P((struct device *parent, struct cfdata *cf, void *aux));
static void salcd_attach __P((struct device *parent, struct device *self, void *aux));

struct cfattach salcd_ca = {
	sizeof(struct salcd_softc), salcd_match, salcd_attach
};

static int
salcd_match(parent, match, aux)
	struct device *parent;
	struct cfdata *match;
	void *aux;
{
	struct lcd_attach_args *la = aux;

	if (strcmp(la->la_name, "lcd") == 0)
		return(1);
	return(0);
}

void
salcd_attach(parent, self, aux)
	struct device *parent;
	struct device *self;
	void *aux;
{
	struct salcd_softc *sc = (struct salcd_softc*)self;
	struct lcd_attach_args *la = aux;

	sc->sc_iot = la->la_iot;
	sc->sc_ioh = la->la_ioh;

	salcd_sc = sc;
	if(bus_space_map(salcd_sc->sc_iot, SALCD_BASE, SALCD_NPORTS, 0, 
			&salcd_sc->sc_ioh))
		panic("%s: Cannot map registers\n", self->dv_xname);

	printf("\n");
}

