/*	$NetBSD: iomd_io_asm.S,v 1.4 1999/10/26 06:53:43 cgd Exp $	*/

/*
 * Copyright (c) 1997 Mark Brinicombe.
 * Copyright (c) 1997 Causality Limited.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Mark Brinicombe.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <machine/asm.h>

/*
 * bus_space I/O functions for saip
 */

/*
 * read single
 */

ENTRY(saip_bs_r_1)
	ldrb	r0, [r1, r2, lsl #2]
	mov	pc, lr

ENTRY(saip_bs_r_2)
	ldr	r0, [r1, r2, lsl #2]
	bic	r0, r0, #0xff000000
	bic	r0, r0, #0x00ff0000
	mov	pc, lr

ENTRY(saip_bs_r_4)
	ldr	r0, [r1, r2, lsl #2]
	mov	pc, lr

/*
 * write single
 */

ENTRY(saip_bs_w_1)
	strb	r3, [r1, r2, lsl #2]
	mov	pc, lr

ENTRY(saip_bs_w_2)
	mov	r3, r3, lsl #16
	orr	r3, r3, r3, lsr #16
	str	r3, [r1, r2, lsl #2]
	mov	pc, lr

ENTRY(saip_bs_w_4)
	str	r3, [r1, r2, lsl #2]
	mov	pc, lr


/*
 * read multiple
 */

ENTRY(saip_bs_rm_1)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	cmp     r2, #0x00000000
	movle   pc, lr

saip_bs_rm_1_loop:
	ldrb	r1, [r3]
	strb	r1, [r0], #0x0001
	subs	r2, r2, #0x00000001
	bgt	saip_bs_rm_1_loop

	mov	pc, lr

ENTRY(saip_bs_rm_2)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	cmp	r2, #0x00000000
	movle	pc, lr

saip_bs_rm_2_loop:
	ldrh	r1, [r3]
	strh	r1, [r0], #0x0002
	subs	r2, r2, #0x00000001
	bgt	saip_bs_rm_2_loop

	mov	pc, lr

ENTRY(saip_bs_rm_4)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	cmp	r2, #0x00000000
	movle	pc, lr

saip_bs_rm_4_loop:
	ldr	r1, [r3]
	str	r1, [r0], #0x0004
	subs	r2, r2, #0x00000001
	bgt	saip_bs_rm_4_loop

	mov	pc, lr

/*
 * write multiple
 */

ENTRY(saip_bs_wm_1)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	cmp	r2, #0x00000000
	movle	pc, lr

saip_wm_1_loop:
	ldrb	r1, [r3], #0x0001
	strb	r1, [r0]
	subs	r2, r2, #0x00000001
	bgt	saip_wm_1_loop

	mov	pc, lr

ENTRY(saip_bs_wm_2)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	cmp	r2, #0x00000000
	movle	pc, lr

saip_bs_wm_2_loop:
	ldrh	r1, [r3], #0x0002
	strh	r1, [r0]
	subs	r2, r2, #0x00000001
	bgt	saip_bs_wm_2_loop

	mov	pc, lr

ENTRY(saip_bs_wm_4)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	cmp	r2, #0x00000000
	movle	pc, lr

saip_bs_wm_4_loop:
	ldrh	r1, [r3], #0x0004
	strh	r1, [r0]
	subs	r2, r2, #0x00000001
	bgt	saip_bs_wm_4_loop

	mov	pc, lr

/*
 * read region
 */

ENTRY(saip_bs_rr_2)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	cmp	r2, #0x00000000
	movle	pc, lr

saip_bs_rr_2_loop:
	ldrh	r1, [r0], #0x0002  
	strh	r1, [r3], #0x0002
        subs    r2, r2, #0x00000001
	bgt	saip_bs_rr_2_loop

        mov     pc, lr

/*
 * write region
 */

ENTRY(saip_bs_wr_2)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	cmp	r2, #0x00000000  
	movle	pc, lr

saip_bs_wr_2_loop:
	ldrh	r1, [r3], #0x0002
	strh	r1, [r0], #0x0002
	subs	r2, r2, #0x00000001
	bgt	saip_bs_wr_2_loop

	mov	pc, lr

/*
 * set regiuon
 */

ENTRY(saip_bs_sr_2)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	cmp	r2, #0x00000000
	movle	pc, lr

saip_bs_sr_2_loop:
	strh	r3, [r0], #0x0002
	subs	r2, r2, #0x00000001
	bgt	saip_bs_sr_2_loop

	mov	pc, lr

/*
 * copy region
 */

ENTRY(saip_bs_c_2)
	add	r0, r1, r2, lsl #2
	ldr	r2, [sp, #0]
	add	r1, r2, r3, lsl #2
	ldr	r2, [sp, #4]
	cmp	r2, #0x00000000
	movle	pc, lr

	cmp	r0, r1
	blt	saip_bs_c_2_backwards

saip_bs_cf_2_loop:
	ldrh	r3, [r0], #0x0002
	strh	r3, [r1], #0x0002
	subs	r2, r2, #0x00000001
	bgt	saip_bs_cf_2_loop

	mov	pc, lr

saip_bs_c_2_backwards:
	add	r0, r0, r2, lsl #1
	add	r1, r1, r2, lsl #1
	sub	r0, r0, #2
	sub	r1, r1, #2

saip_bs_cb_2_loop:
	ldrh	r3, [r0], #-2
	strh	r3, [r1], #-2
	subs	r2, r2, #1
	bne	saip_bs_cb_2_loop

	mov     pc, lr
