/*      $Id: sacom.c,v 1.7 2001/02/17 05:18:38 ichiro Exp $ */
/*      $NetBSD: chio.h,v 1.10 1999/09/09 23:24:11 thorpej Exp $        */

/*-
 * Copyright (c) 2001, The NetBSD Foundation, Inc.  All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by IWAMOTO Toshihiro.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the NetBSD
 *      Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/types.h>
#include <sys/conf.h>
#include <sys/device.h>
#include <sys/tty.h>

#include <dev/cons.h>

#include <machine/bus.h>
#include <hpcarm/sa/saipreg.h>
#include <hpcarm/sa/sacomreg.h>
#include <hpcarm/sa/sacomvar.h>
#include <hpcarm/sa/saipvar.h>

cdev_decl(sacom);

int sacomcngetc		__P((dev_t));
void sacomcnputc	__P((dev_t, int));
void sacomcnpollc	__P((dev_t, int));

/* these actually belong to bus space code */
void sacomcnprobe	__P((struct consdev *));
void sacomcninit	__P((struct consdev *));

extern struct bus_space mainbus_bs_tag;

static bus_space_tag_t sacomconstag;
static bus_space_handle_t sacomconsioh;

static struct sacom_softc *sacom_sc;

static int sacom_match   __P((struct device *parent, struct cfdata *cf, void *aux));
static void sacom_attach __P((struct device *parent, struct device *self, void *aux));

struct cfattach sacom_ca = {
	sizeof(struct sacom_softc), sacom_match, sacom_attach
};

#ifndef CONMODE
#define CONMODE ((TTYDEF_CFLAG & ~(CSIZE | CSTOPB | PARENB)) | CS8) /* 8N1 */
#endif
#ifndef CONSPEED
#define CONSPEED 9600
#endif
#ifndef CONADDR
#define CONADDR SACOM3_BASE
#endif

static int
sacom_match(parent, match, aux)
	struct device *parent;
	struct cfdata *match;
	void *aux;
{
	struct urt_attach_args *ua = aux;

	if (strcmp(ua->ua_name, "urt") == 0)
		return(1);
	return(0);
}

void
sacom_attach(parent, self, aux)
	struct device *parent;
	struct device *self;
	void *aux;
{
	struct sacom_softc *sc = (struct sacom_softc*)self;
	struct urt_attach_args *ua = aux;

	sc->sc_iot = ua->ua_iot;
	sc->sc_ioh = ua->ua_ioh;

	sacom_sc = sc;

	printf("\n");
}

int
sacominit(iot, iobase, baud, cflag, iohp)
	bus_space_tag_t iot;
	bus_addr_t iobase;
	int baud;
	tcflag_t cflag;
	bus_space_handle_t *iohp;
{
	int brd, cr0;

	if (bus_space_map(iot, iobase, SACOM_NPORTS, 0, iohp))
		printf("register map failed\n");

	/* disable the UART */
	bus_space_write_4(iot, *iohp, SACOM_CR3, 0);

	cr0 = (cflag & PARENB) ? CR0_PE : 0;
	cr0 |= (cflag & CS8) ? CR0_DSS : 0;
	bus_space_write_4(iot, *iohp, SACOM_CR0, cr0);

	brd = SACOMSPEED(baud);
	/* XXX assumes little endian */
	bus_space_write_4(iot, *iohp, SACOM_CR1, brd >> 8);
	bus_space_write_4(iot, *iohp, SACOM_CR2, brd & 0xff);

	/* enable the UART */
	bus_space_write_4(iot, *iohp, SACOM_CR3, CR3_RXE | CR3_TXE);

	return (0);
}

/* console support code */
struct consdev sacomcons = {
	NULL, NULL, sacomcngetc, sacomcnputc, sacomcnpollc, NULL,
	NODEV, CN_NORMAL
};

void
sacomcnprobe(cp)
	struct consdev *cp;
{
	cp->cn_pri = CN_REMOTE;
}

void
sacomcninit(cp)
	struct consdev *cp;
{
#if 1 /* XXX fucked */
	if (cp == NULL) {
		if (sacominit(&mainbus_bs_tag, SACOM3_HW_BASE,
				  CONSPEED, CONMODE, &sacomconsioh))
			panic("can't init serial console @%x", CONADDR);
		sacomconstag = &mainbus_bs_tag;
		cn_tab = &sacomcons;
		return;
	}
#endif
	if (sacominit(&mainbus_bs_tag, CONADDR, CONSPEED,
			  CONMODE, &sacomconsioh))
		panic("can't init serial console @%x", CONADDR);
	cn_tab = &sacomcons;
	sacomconstag = &mainbus_bs_tag;
}

int
sacomcngetc(dev)
	dev_t dev;
{
	int c, s;

	s = spltty();	/* XXX do we need this? */

	while(! (bus_space_read_4(sacomconstag, sacomconsioh, SACOM_SR1)
		 & SR1_RNE))
		;

	c = bus_space_read_4(sacomconstag, sacomconsioh, SACOM_DR);
	c &= 0xff;
	splx(s);

	return (c);
}

void
sacomcnputc(dev, c)
	dev_t dev;
	int c;
{
	int s;

	s = spltty();	/* XXX do we need this? */

	while(! (bus_space_read_4(sacomconstag, sacomconsioh, SACOM_SR1)
		 & SR1_TNF))
		;

	bus_space_write_4(sacomconstag, sacomconsioh, SACOM_DR, c);
	splx(s);
}

void
sacomcnpollc(dev, on)
	dev_t dev;
	int on;
{

}
