/*	$Id: saost.c,v 1.7 2001/02/16 02:45:22 toshii Exp $ */

/*	$NetBSD: chio.h,v 1.10 1999/09/09 23:24:11 thorpej Exp $	*/

/*-
 * Copyright (c) 2001, The NetBSD Foundation, Inc.  All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by IWAMOTO Toshihiro and Ichiro FUKUHARA.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/time.h>
#include <sys/device.h>

#include <machine/bus.h>
#include <machine/irqhandler.h>
#include <machine/cpufunc.h>
#include <machine/katelib.h>
#include <hpcarm/sa/saipreg.h> 
#include <hpcarm/sa/saipvar.h>
#include <hpcarm/sa/saostreg.h>

struct saost_softc {
	struct device sc_dev;
	bus_space_tag_t sc_iot;
	bus_space_handle_t sc_ioh;
};

static struct saost_softc *saost_sc;

#define TIMER_FREQUENCY         3686400         /* 3.6468MHz */
#define TICKS_PER_MICROSECOND   (TIMER_FREQUENCY/1000000)

int	gettick __P((void));
int	clockintr __P((void *));
void	rtcinit __P((void));

static int saost_match   __P((struct device *parent, struct cfdata *cf, void *aux));
static void saost_attach __P((struct device *parent, struct device *self, void *aux));

static bus_space_tag_t saoststag;
static bus_space_handle_t saostsioh;

struct cfattach saost_ca = {
	sizeof(struct saost_softc), saost_match, saost_attach
};

static int
saost_match(parent, match, aux)
	struct device *parent;
	struct cfdata *match;
	void *aux;
{
	struct clk_attach_args *ca = aux;

	if (strcmp(ca->ca_name, "clk") == 0)
		return(1);
	return(0);
}

void
saost_attach(parent, self, aux)
	struct device *parent;
	struct device *self;
	void *aux;
{
	struct saost_softc *sc = (struct saost_softc*)self;
	struct clk_attach_args *ca = aux;

	sc->sc_iot = saoststag = ca->ca_iot;
	sc->sc_ioh = saostsioh = ca->ca_ioh;

	saost_sc = sc;

	bus_space_map(sc->sc_iot, SAOST_BASE, OST_NPORTS, 0, &sc->sc_ioh);

	printf("\nsaost_attached\n");
}

int
clockintr(arg)
	void *arg;
{
	hardclock((struct clockframe *)arg);
	return(1);
}


void
setstatclockrate(hz)
	int hz;
{
	/* XXX */
}

void
cpu_initclocks()
{
	/* initialize saost and setup irq */
	unsigned int otick;
	printf("clock: hz=%d stathz = %d profhz = %d\n", hz, stathz, profhz);
	otick = gettick();
	printf("gettick: %d \n",otick);
}

int
gettick()
{
	int counter;
	u_int savedints;
	/* Don't want someone screwing with the counter while we're here. */
	savedints = disable_interrupts(I32_bit);

	counter = bus_space_read_4(saoststag, saostsioh, OST_OSCR);

	restore_interrupts(savedints);
	return counter;
}

void
microtime(tvp)
	register struct timeval *tvp;
{
	int s = splhigh();
	static struct timeval lasttime;

	*tvp = time;
	tvp->tv_usec++;         /* XXX */
	while (tvp->tv_usec >= 1000000) {
		tvp->tv_sec++;
		tvp->tv_usec -= 1000000;
	}

#if 0
        u_int32_t oscr;
        oscr = bus_space_read_4(saost_iot, saost_ioh, SAOST_CR);
        /* XXX do something */
#endif

	if (tvp->tv_sec == lasttime.tv_sec &&
		tvp->tv_usec <= lasttime.tv_usec &&
		(tvp->tv_usec = lasttime.tv_usec + 1) >= 1000000)
	{
		tvp->tv_sec++;
		tvp->tv_usec -= 1000000;
	}
	lasttime = *tvp;
	splx(s);
}

void
delay(usecs)
	u_int usecs;
{
	unsigned int limit, tick, otick;

	usecs *= TICKS_PER_MICROSECOND;

	otick = gettick();
	limit = 0xffffffff;

	while (usecs > 0) {
		tick = gettick();
		if (tick < otick)
			usecs -= limit - (otick - tick);
		else
			usecs -= tick - otick;
		otick = tick;
	}
}

void
resettodr()
{
}

void
inittodr(base)
	time_t base;
{
	time.tv_sec = base;
	time.tv_usec = 0;
}
