/*	$Id: saip.c,v 1.11 2001/02/16 02:19:19 ichiro Exp $ */
/*	$NetBSD: vrip.c,v 1.5 2000/03/05 05:22:13 takemura Exp $	*/

/*-
 * Copyright (c) 2001, The NetBSD Foundation, Inc.  All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by IWAMOTO Toshihiro and Ichiro FUKUHARA.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the NetBSD
 *      Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */
/*-
 * Copyright (c) 1999
 *         Shin Takemura and PocketBSD Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the PocketBSD project
 *	and its contributors.
 * 4. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <sys/reboot.h>

#include <machine/cpu.h>
#include <machine/bus.h>

#include <hpcarm/mainbus/mainbus.h>
#include <hpcarm/sa/saipreg.h>
#include <hpcarm/sa/saipvar.h>


static int	saipmatch __P((struct device*, struct cfdata*, void*));
static void	saipattach __P((struct device*, struct device*, void*));
static int	saipprint __P((void*, const char*));

struct cfattach saip_ca = {
	sizeof(struct saip_softc), saipmatch, saipattach
};

extern struct bus_space saip_bs_tag;

#ifdef INTRTEST  /* XXX */
void hoge(void *p)
{
	printf("hoge\n");
}
#endif

/*
 * int iomdprint(void *aux, const char *name)
 * print configuration info for children
 */

static int
saipprint(aux, name)
	void *aux;
	const char *name;
{
        return(QUIET);
}

int
saipmatch(parent, match, aux)
	struct device *parent;
	struct cfdata *match;
	void *aux;
{
	return 1;
}

void
saipattach(parent, self, aux)
	struct device *parent;
	struct device *self;
	void *aux;
{
	/* struct mainbus_attach_args *ma = aux; */
	struct saip_softc *sc = (struct saip_softc*)self;

	union saip_attach_args sa;
	bus_space_tag_t iot;
	bus_space_handle_t ioh;
	
	iot = sc->sc_iot = &saip_bs_tag;

	/* Map the SAIP */
	if (bus_space_map(iot, SAIPIC_BASE, SAIPIC_NPORTS,
			0, &ioh))
		panic("%s: Cannot map registers\n", self->dv_xname);
	sc->sc_ioh = ioh;

	printf("\n");

	/*
	 *  Mask all interrupts.
	 *  They are later unmasked at each device's attach routine.
	 */
	bus_space_write_4(sc->sc_iot, sc->sc_ioh, SAIPIC_MR, 0);

	/* Route all bits to IRQ */
	bus_space_write_4(sc->sc_iot, sc->sc_ioh, SAIPIC_LR, 0);

	/* Clear idle mask */
	bus_space_write_4(sc->sc_iot, sc->sc_ioh, SAIPIC_CR, 0);

	/* Attach clock device */
	sa.sa_clk.ca_name = "clk";
	sa.sa_clk.ca_iot = iot;
	sa.sa_clk.ca_ioh = ioh;
	config_found(self, &sa, saipprint);

	/* Attach UART device */
	sa.sa_urt.ua_name = "urt";
	sa.sa_urt.ua_iot = iot;
	sa.sa_urt.ua_ioh = ioh;
	config_found(self, &sa, saipprint);

#ifdef INTRTEST  /* XXX */
	saip_intr_establish(0, 30, 1, IPL_BIO, hoge, 0);
	*((u_int32_t *)0xd0001010) = 0x8;
	SetCPSR(I32_bit, 0);
#endif

#if 0
	/*
	 *  Attach each devices
	 */
	config_search(vrip_search, self, vrip_print);
#endif
}
