#ifndef __NETBSD_DM_H__
#define __NETBSD_DM_H__

#include <prop/proplib.h>

#define DM_IOCTL 0xfd

#define DM_IOCTL_CMD 0

#define NETBSD_DM_IOCTL       _IOWR(DM_IOCTL, DM_IOCTL_CMD, struct plistref)

#ifdef __LIB_DEVMAPPER__

/* libdm_netbsd.c */

struct nbsd_dm_ioctl * nbsd_create_dm_ioctl(void);

int nbsd_dmi_add_cmd(const char *, prop_dictionary_t);
int nbsd_dmi_add_version(const int [3], prop_dictionary_t);
int nbsd_dm_add_uint(const char *, uint64_t, prop_dictionary_t);
int nbsd_dm_add_str(const char *, char *, prop_dictionary_t );

struct dm_ioctl* nbsd_dm_dict_to_dmi(prop_dictionary_t);

#endif /* __LIB_DEVMAPPER__ */

#endif /* __NETBSD_DM_H__ */
