/*	$NetBSD: intro.c,v 1.4 2007/11/28 16:59:02 pooka Exp $	*/

/*
 * El extra-simplo example of the userspace driver framework.
 *
 * Eventually there will be a library a la libpuffs (perhaps,
 * gasp, even the same lib), but for now it's all manual until
 * I get it figured out.
 *
 * So how to run this?
 * 0) sh MAKEDEV putter (if you don't have a freshly created /dev)
 * 1) run this program with the argument "/dev/pud"
 * 2) mknod a char device with the major 377 (see sources below)
 * 3) echo ascii art and jokes into device created in previous step
 *    or read the device
 */

#include <sys/types.h>

#include <dev/pud/pud_msgif.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/ioctl.h>

#include "dm-ioctl.h"
#include "netbsd-dm.h"
#include "dm.h"

#define DM_MAJOR_PUD 377
#define PUD_DEV "/dev/pud"

#define EPASSTHROUGH -4

#ifndef MIN
#define MIN(a,b) ((a)<(b)?(a):(b))
#endif

#define  DEFALLOC 16384


static int dm_ioctl_switch(u_long);

int
main(int argc, char *argv[])
{
	struct pud_req *pdr = malloc(DEFALLOC);
	struct pud_conf_reg pcr;
	int fd;
	ssize_t n;
	
	/*
	 * open pud device
	 */
	fd = open(PUD_DEV, O_RDWR);
	if (fd == -1)
		err(1, "open");

	/*
	 * register our major number
	 */
	memset(&pcr, 0, sizeof(pcr));
	pcr.pm_pdr.pdr_pth.pth_framelen = sizeof(struct pud_conf_reg);
	pcr.pm_version = PUD_DEVELVERSION | PUD_VERSION;
	pcr.pm_pdr.pdr_reqclass = PUD_REQ_CONF;
	pcr.pm_pdr.pdr_reqtype = PUD_CONF_REG;

	pcr.pm_regdev = makedev(DM_MAJOR_PUD, 0);
	pcr.pm_flags = PUD_CONFFLAG_BDEV;
	strlcpy(pcr.pm_devname, "control", sizeof(pcr.pm_devname));

	n = write(fd, &pcr, pcr.pm_pdr.pdr_pth.pth_framelen);
	if (n == -1)
		err(1, "configure write");

	/*
	 * process requests
	 */
	for (;;) {
		n = read(fd, pdr, DEFALLOC);
		printf("read %d %d\n", n, errno);

		switch (pdr->pdr_reqtype) {
		case PUD_CDEV_OPEN:
			printf("open routine %d\n",pdr->pdr_reqtype);
			pdr->pdr_rv = 0;
			break;
			
		case PUD_CDEV_CLOSE:
			printf("got openclose %d\n", pdr->pdr_reqtype);
			pdr->pdr_rv = 0;
			break;

		case PUD_CDEV_IOCTL:
		{
			prop_dictionary_t dm_dict_in,dm_dict_out;
			struct pud_req_ioctl *pc_ioctl;
			int *iocval;
			int error;
			
			printf("ioctl routine called\n");
			
			pc_ioctl = (void *)pdr;
			
			if ((dm_ioctl_switch(pc_ioctl->pm_iocmd)) == 0) {
				
				const struct plistref *pref =
				    (const struct plistref *) pc_ioctl->pm_data;

				error = prop_dictionary_copyin_ioctl(pref,
				    pc_ioctl->pm_iocmd, &dm_dict_in);

				if (error)
					return (error);

				prop_dictionary_externalize_to_file(dm_dict_in,"/tmp/dm_in");
			}
		}
		break;

		default:
			abort();
		}

		n = write(fd, pdr, pdr->pdr_pth.pth_framelen);
		printf("wrote %d %d\n", n, errno);
	}
}


/* Call apropriate ioctl handler function. */
static int
dm_ioctl_switch(u_long cmd)
{

	int r;

	r = 0;
	
	switch(cmd) {

	case NETBSD_DM_IOCTL:
		printf("NETBSD_DM_IOCTL ioctl called\n");
		break;

	default:
		printf("unknown ioctl called\n");
		return EPASSTHROUGH;
		break; /* NOT REACHED */
	}

	return r;
}
