/* Subroutines to go with GOLDDIG program.  These routines are packaged */
/* in this routine and this fashion in order to minimize changes to the */
/* other routines.                          */
/*                                  */
/* These routines handle timer and X event notification requests.   */
/*                                  */
/*  Written 1-Dec-1989 by B. Thomas                 */

#include <stdio>
#include <signal>
#include <ssdef>

static unsigned int timer_interval[2];
static unsigned int status;
static unsigned int reqidt;

static void set_timer()

/* Post a timer request */

{
    static void ast_routine();

/* post the request */

    status = sys$setimr(NULL,timer_interval,ast_routine,reqidt,NULL);

/* If it failed, die and say so */

    if (status != SS$_NORMAL) lib$signal(status);
}

static void ast_routine()
/* Routine to handle the timer request.  Simply raise the signal and then */
/* set a new request */

{
    gsignal(SIGALRM);       /* Raise the signal */
    set_timer();            /* Ask for a new timer request */
}

void setitimer(usec)
    int usec;

/* Initial set up for timer requests.  Cancel any existing timers; compute */
/* the amount of time to wait (based on the input parameter) and then ask */
/* for the timer request */

{

/* Cancel any existing requests */

    status  = sys$cantim(reqidt,NULL);

/* Bump the id so that we can cancel this request later if need be */

    ++reqidt;

/* Compute the time in units needed for SYS$SETIMR from the usec parameter */

    timer_interval[0] = -10 * usec;
    timer_interval[1] = -1;

/* Ask for the timer request */

    set_timer();
}
